/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Vector;

public class gfmView
extends Canvas {
    protected gfmFrame m_Frame;
    protected Graphics m_g;
    protected Image m_Scene;
    protected Graphics m_SceneGraphics;
    protected int m_SceneWidth;
    protected int m_SceneHeight;
    protected int m_MDOx;
    protected int m_MDOy;
    protected int m_DAOx;
    protected int m_DAOy;
    protected double m_xScale;
    protected double m_yScale;
    protected boolean m_DrawingPoint = false;
    protected boolean m_DrawingLine = false;
    protected boolean m_DrawingPolygon = false;
    protected boolean m_ShowCoordinates = true;
    protected Vector m_Line;
    protected gfmPolygon m_Polygon;
    protected boolean m_FirstPoint = true;
    protected boolean m_MouseDown = false;
    protected int m_strokeCount;
    protected int m_xOrig;
    protected int m_yOrig;
    protected int m_xOld;
    protected int m_yOld;
    protected int m_xPrev;
    protected int m_yPrev;

    public gfmView(gfmFrame gfmFrame2) {
        this.m_Frame = gfmFrame2;
        this.setBackground(Color.white);
        this.m_SceneWidth = 600;
        this.m_SceneHeight = 300;
        this.m_MDOx = 50;
        this.m_MDOy = this.m_SceneHeight - this.m_MDOx;
        this.m_xScale = 0.0;
        this.m_yScale = 0.0;
        this.m_DAOx = 0;
        this.m_DAOy = 0;
        this.m_Line = new Vector();
        this.m_Polygon = new gfmPolygon();
    }

    public void AddToScene() {
    }

    public gfmPoint DisplayAreaToModelDomain(int n, int n2) {
        double d = (double)(n - this.m_MDOx + this.m_DAOx) / this.m_xScale;
        double d2 = (double)(n2 - this.m_MDOy + this.m_DAOy) / this.m_yScale;
        return new gfmPoint(d, d2);
    }

    public gfmPoint DisplayAreaToModelDomain(Point point) {
        double d = (double)(point.x - this.m_MDOx + this.m_DAOx) / this.m_xScale;
        double d2 = (double)(point.y - this.m_MDOy + this.m_DAOy) / this.m_yScale;
        return new gfmPoint(d, d2);
    }

    public void DrawBackground() {
        Graphics graphics = this.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.size().width, this.size().height);
    }

    public void DrawScene() {
    }

    public void EnableDrawingLine(boolean bl) {
        this.m_DrawingLine = bl;
        if (this.m_DrawingLine) {
            this.m_DrawingPoint = false;
            this.m_DrawingPolygon = false;
        }
    }

    public void EnableDrawingPoint(boolean bl) {
        this.m_DrawingPoint = bl;
        if (this.m_DrawingPoint) {
            this.m_DrawingLine = false;
            this.m_DrawingPolygon = false;
        }
    }

    public void EnableDrawingPolygon(boolean bl) {
        this.m_DrawingPolygon = bl;
        if (this.m_DrawingPolygon) {
            this.m_DrawingPoint = false;
            this.m_DrawingLine = false;
        }
    }

    public int GetDAOx() {
        return this.m_DAOx;
    }

    public int GetDAOy() {
        return this.m_DAOy;
    }

    public int GetMDOx() {
        return this.m_MDOx;
    }

    public int GetMDOy() {
        return this.m_MDOy;
    }

    public int GetSceneHeight() {
        return this.m_SceneHeight;
    }

    public int GetSceneWidth() {
        return this.m_SceneWidth;
    }

    public boolean IsDrawing() {
        return !this.m_FirstPoint;
    }

    public Point ModelDomainToScene(double[] dArray) {
        return this.ModelDomainToScene(dArray[0], dArray[1]);
    }

    public Point ModelDomainToScene(gfmPoint gfmPoint2) {
        int n = (int)(gfmPoint2.xx * this.m_xScale + (double)this.m_MDOx + 0.5);
        int n2 = (int)(gfmPoint2.yy * this.m_yScale + (double)this.m_MDOy + 0.5);
        return new Point(n, n2);
    }

    public Point ModelDomainToScene(double d, double d2) {
        int n = (int)(d * this.m_xScale + (double)this.m_MDOx + 0.5);
        int n2 = (int)(d2 * this.m_yScale + (double)this.m_MDOy + 0.5);
        return new Point(n, n2);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.m_Frame.IsBusy()) {
            return true;
        }
        if (n > this.m_SceneWidth || n2 > this.m_SceneHeight) {
            return true;
        }
        if (this.m_DrawingPoint) {
            gfmPoint gfmPoint2 = this.DisplayAreaToModelDomain(n, n2);
            this.m_DrawingPoint = false;
            this.m_Frame.OnFinishedDrawingPoint(gfmPoint2.xx, gfmPoint2.yy);
            return true;
        }
        if (this.m_DrawingLine) {
            gfmPoint gfmPoint3 = this.DisplayAreaToModelDomain(n, n2);
            if (this.m_FirstPoint) {
                this.m_Line.removeAllElements();
                this.m_g = this.getGraphics();
                this.m_g.clipRect(0, 0, this.m_SceneWidth, this.m_SceneHeight);
                this.m_g.setColor(Color.black);
                this.m_FirstPoint = false;
            }
            this.m_Line.addElement(gfmPoint3);
            this.m_xOld = n;
            this.m_yOld = n2;
            this.m_xPrev = n;
            this.m_yPrev = n2;
            if (event.shiftDown() || event.controlDown()) {
                this.m_FirstPoint = true;
                this.m_DrawingLine = false;
                this.m_Frame.OnFinishedDrawingLine(this.m_Line);
            }
            return true;
        }
        if (this.m_DrawingPolygon) {
            this.m_MouseDown = true;
            if (this.m_FirstPoint) {
                this.m_Polygon.Empty();
                this.m_g = this.getGraphics();
                this.m_g.clipRect(0, 0, this.m_SceneWidth, this.m_SceneHeight);
                this.m_g.setColor(Color.black);
                this.m_xOrig = n;
                this.m_yOrig = n2;
                this.m_strokeCount = 1;
                this.m_FirstPoint = false;
            } else {
                ++this.m_strokeCount;
            }
            this.m_Polygon.AddPoint(this.DisplayAreaToModelDomain(n, n2));
            this.m_xOld = n;
            this.m_yOld = n2;
            this.m_xPrev = n;
            this.m_yPrev = n2;
            if (event.shiftDown() || event.controlDown()) {
                this.m_FirstPoint = true;
                this.m_DrawingPolygon = false;
                this.m_Frame.OnFinishedDrawingPolygon(this.m_Polygon);
            }
            return true;
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.m_Frame.IsBusy()) {
            return true;
        }
        this.m_Frame.SetProgramStatusLabel("Ready");
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.m_Frame.IsBusy()) {
            return true;
        }
        if (this.m_ShowCoordinates) {
            if (n <= this.m_SceneWidth && n2 <= this.m_SceneHeight && this.m_xScale != 0.0 && this.m_yScale != 0.0) {
                gfmPoint gfmPoint2 = this.DisplayAreaToModelDomain(n, n2);
                this.m_Frame.SetProgramStatusLabel("(" + (int)(gfmPoint2.xx + 0.5) + ", " + (int)(gfmPoint2.yy + 0.5) + ")");
            } else {
                this.m_Frame.SetProgramStatusLabel("Ready");
            }
        }
        if (this.m_DrawingLine && !this.m_FirstPoint) {
            this.m_g.setColor(Color.white);
            this.m_g.setXORMode(Color.black);
            this.m_g.drawLine(this.m_xPrev, this.m_yPrev, this.m_xOld, this.m_yOld);
            this.m_g.drawLine(this.m_xPrev, this.m_yPrev, n, n2);
            this.m_xOld = n;
            this.m_yOld = n2;
            return true;
        }
        if (this.m_DrawingPolygon && !this.m_FirstPoint) {
            this.m_g.setColor(Color.white);
            this.m_g.setXORMode(Color.black);
            if (this.m_strokeCount == 1) {
                if (this.m_MouseDown) {
                    this.m_MouseDown = false;
                } else {
                    this.m_g.drawLine(this.m_xPrev, this.m_yPrev, this.m_xOld, this.m_yOld);
                }
                this.m_g.drawLine(this.m_xPrev, this.m_yPrev, n, n2);
            } else {
                if (this.m_MouseDown) {
                    if (this.m_strokeCount > 2) {
                        this.m_g.drawLine(this.m_xOld, this.m_yOld, this.m_xOrig, this.m_yOrig);
                    }
                    this.m_MouseDown = false;
                } else {
                    this.m_g.drawLine(this.m_xPrev, this.m_yPrev, this.m_xOld, this.m_yOld);
                    this.m_g.drawLine(this.m_xOld, this.m_yOld, this.m_xOrig, this.m_yOrig);
                }
                this.m_g.drawLine(this.m_xPrev, this.m_yPrev, n, n2);
                this.m_g.drawLine(n, n2, this.m_xOrig, this.m_yOrig);
            }
            this.m_xOld = n;
            this.m_yOld = n2;
            return true;
        }
        return true;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void SetDAOx(int n) {
        int n2 = n - this.m_DAOx;
        this.m_xOrig -= n2;
        this.m_xOld -= n2;
        this.m_xPrev -= n2;
        this.m_DAOx = n;
    }

    public void SetDAOy(int n) {
        int n2 = n - this.m_DAOy;
        this.m_yOrig -= n2;
        this.m_yOld -= n2;
        this.m_yPrev -= n2;
        this.m_DAOy = n;
    }

    public void SetScale(double d, double d2) {
        this.m_xScale = (double)(this.m_SceneWidth - 2 * this.m_MDOx) / d;
        this.m_yScale = -this.m_xScale * d2;
    }

    public void SetSceneHeight(int n) {
        this.m_SceneHeight = n;
        this.m_MDOy = this.m_SceneHeight - this.m_MDOx;
        this.m_Frame.repaint();
    }

    public void ShowCoordinates(boolean bl) {
        this.m_ShowCoordinates = bl;
    }

    public void update(Graphics graphics) {
        if (this.m_Scene == null) {
            this.m_Scene = this.createImage(this.m_SceneWidth, this.m_SceneHeight);
            this.m_SceneGraphics = this.m_Scene.getGraphics();
            this.m_SceneGraphics.setColor(Color.white);
            this.m_SceneGraphics.fillRect(0, 0, this.m_SceneWidth, this.m_SceneHeight);
        }
        graphics.translate(-this.m_DAOx, -this.m_DAOy);
        graphics.drawImage(this.m_Scene, 0, 0, this);
    }

    public void Zoom(double d) {
        this.m_SceneWidth = (int)((double)this.m_SceneWidth * d + 0.5);
        this.m_SceneHeight = (int)((double)this.m_SceneHeight * d + 0.5);
        this.m_MDOx = (int)((double)this.m_MDOx * d + 0.5);
        this.m_MDOy = this.m_SceneHeight - this.m_MDOx;
        this.m_xScale *= d;
        this.m_yScale *= d;
    }
}

