/*
 * Decompiled with CFR 0.152.
 */
public class gfmStreamFunctionModel
extends gfmModel {
    protected double[][] m_HydrCond;
    protected double[][] m_VelocityDirection;
    protected double[] m_VelocityMagnitude;
    protected double[] m_Porosity;

    public void Clear() {
        super.Clear();
        this.m_HydrCond = null;
        this.m_Porosity = null;
        this.m_VelocityDirection = null;
        this.m_VelocityMagnitude = null;
    }

    public void ComputeVelocity() {
        int n = this.m_Mesh.GetNumberOfElements();
        this.m_VelocityDirection = new double[n][2];
        this.m_VelocityMagnitude = new double[n];
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        int n2 = 0;
        while (n2 < n) {
            this.m_Mesh.GetElement(n2).ComputeDerivatives(this.b, dArray);
            int n3 = this.m_PropertyIndex[n2];
            dArray2[0] = -dArray[1] / (this.m_Porosity[n3] * 0.01);
            dArray2[1] = dArray[0] / (this.m_Porosity[n3] * 0.01);
            this.m_VelocityMagnitude[n2] = gfmMath.VectorMagnitude(dArray2);
            this.m_VelocityDirection[n2][0] = dArray2[0] / this.m_VelocityMagnitude[n2];
            this.m_VelocityDirection[n2][1] = dArray2[1] / this.m_VelocityMagnitude[n2];
            ++n2;
        }
    }

    public double[] GetValues() {
        return this.b;
    }

    public double[][] GetVelocityDirection() {
        return this.m_VelocityDirection;
    }

    public double[] GetVelocityMagnitude() {
        return this.m_VelocityMagnitude;
    }

    public void SetConductivity(double[][] dArray) {
        this.m_HydrCond = dArray;
    }

    public void SetPorosity(double[] dArray) {
        this.m_Porosity = dArray;
    }

    public void Solve() {
        double d;
        int n;
        int n2;
        int n3 = this.m_Mesh.GetHalfBandWidth();
        int n4 = this.m_Mesh.GetNumberOfElements();
        int n5 = this.m_Mesh.GetNumberOfNodes();
        this.A = new double[n5 * n3];
        this.b = new double[n5];
        int n6 = 0;
        while (n6 < this.A.length) {
            this.A[n6] = 0.0;
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.b.length) {
            this.b[n7] = 0.0;
            ++n7;
        }
        double[] dArray = new double[2];
        int n8 = 0;
        while (n8 < n4) {
            n2 = this.m_PropertyIndex[n8];
            dArray[0] = 1.0 / this.m_HydrCond[n2][1];
            dArray[1] = 1.0 / this.m_HydrCond[n2][0];
            this.m_Mesh.GetElement(n8).AssembleGlobal(this.A, n3, dArray);
            ++n8;
        }
        if (this.m_NumBoundaryFlux > 0) {
            n2 = 0;
            while (n2 < this.m_NumBoundaryFlux) {
                int n9 = this.m_BoundaryFlux[n2].nodeId1;
                n = this.m_BoundaryFlux[n2].nodeId2;
                d = this.m_BoundaryFlux[n2].value;
                double[] dArray2 = this.m_Mesh.GetNode(n9);
                double[] dArray3 = this.m_Mesh.GetNode(n);
                double d2 = gfmMath.DistanceBetweenTwoPoints(dArray2, dArray3);
                int n10 = n9;
                this.b[n10] = this.b[n10] + d2 * d / 2.0;
                int n11 = n;
                this.b[n11] = this.b[n11] + d2 * d / 2.0;
                ++n2;
            }
        }
        if (this.m_NumBoundaryValue > 0) {
            double d3 = 0.0;
            n = 0;
            while (n < n5) {
                d3 += this.A[n3 * n] / (double)n5;
                ++n;
            }
            d = d3 * 1.0E10;
            int n12 = 0;
            while (n12 < this.m_NumBoundaryValue) {
                int n13 = this.m_BoundaryValue[n12].nodeId;
                int n14 = n3 * n13;
                this.A[n14] = this.A[n14] + d;
                int n15 = n13;
                this.b[n15] = this.b[n15] + d * this.m_BoundaryValue[n12].value;
                ++n12;
            }
        }
        gfmMath.SymBandSolver(this.A, this.b, n5, n3);
    }
}

