/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;

public class gfmPropertiesDialog
extends gfmDialog {
    private gfmColorSquare[] m_ColorSquare;
    private Color[] m_Color;
    private double[][] m_HydrCond;
    private double[] m_Porosity;
    private int m_NumProperties;
    private int m_CurrentPropertyIndex;
    private int m_SelectedPropertyIndex;
    private boolean m_Isotropic = true;
    private boolean m_Randomize = true;
    private TextField[][] m_HydrCondTextField;
    private TextField[] m_PorosityTextField;
    private String[][] m_HydrCondText;
    private String[] m_PorosityText;
    private Checkbox m_RandomizeCheckbox;

    public gfmPropertiesDialog(Frame frame, Color[] colorArray, double[][] dArray, double[] dArray2, int n, int n2, boolean bl) {
        super(frame, "Properties");
        this.m_Color = colorArray;
        this.m_HydrCond = dArray;
        this.m_Porosity = dArray2;
        this.m_NumProperties = n;
        this.m_SelectedPropertyIndex = n2;
        this.m_CurrentPropertyIndex = n2;
        this.m_Isotropic = bl;
        this.m_ColorSquare = new gfmColorSquare[this.m_NumProperties];
        this.m_HydrCondTextField = new TextField[this.m_NumProperties][2];
        this.m_PorosityTextField = new TextField[this.m_NumProperties];
        this.m_HydrCondText = new String[this.m_NumProperties][2];
        this.m_PorosityText = new String[this.m_NumProperties];
        this.MakeContents();
    }

    protected void MakeContents() {
        gfmPanel gfmPanel2 = new gfmPanel(10, 10, 0, 10);
        gfmPanel2.setLayout(new FlowLayout(1));
        gfmPanel2.add(new gfmColorSquare(this, -1, Color.white, 40));
        gfmPanel gfmPanel3 = new gfmPanel(0, 6, 0, 0);
        if (this.m_Isotropic) {
            gfmPanel3.setLayout(new GridLayout(2, 2));
            gfmPanel3.add(new Label("Hydraulic conductivity", 1));
            gfmPanel3.add(new Label("Porosity", 1));
            gfmPanel3.add(new Label("(m/s)", 1));
            gfmPanel3.add(new Label("(Percent)", 1));
        } else {
            gfmPanel3.setLayout(new GridLayout(2, 3));
            gfmPanel3.add(new Label("  Horiz Hydr Cond   ", 1));
            gfmPanel3.add(new Label("   Vert Hydr Cond   ", 1));
            gfmPanel3.add(new Label("      Porosity      ", 1));
            gfmPanel3.add(new Label("    (m/s)     ", 1));
            gfmPanel3.add(new Label("    (m/s)     ", 1));
            gfmPanel3.add(new Label("  (Percent)   ", 1));
        }
        gfmPanel2.add(gfmPanel3);
        this.add("North", gfmPanel2);
        super.MakeContents();
    }

    protected void AddComponentsToCenterPanel(gfmPanel gfmPanel2, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        int n = 0;
        while (n < this.m_NumProperties) {
            this.m_ColorSquare[n] = new gfmColorSquare(this, n, this.m_Color[n], 40);
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.m_ColorSquare[n], gridBagConstraints);
            gfmPanel2.add(this.m_ColorSquare[n]);
            int n2 = 0;
            while (n2 < 2) {
                this.m_HydrCondText[n][n2] = new String(String.valueOf(this.m_HydrCond[n][n2]));
                this.m_HydrCondTextField[n][n2] = new TextField(15);
                ((TextComponent)this.m_HydrCondTextField[n][n2]).setText(this.m_HydrCondText[n][n2]);
                if (n2 == 0 || n2 == 1 && !this.m_Isotropic) {
                    gridBagLayout.setConstraints(this.m_HydrCondTextField[n][n2], gridBagConstraints);
                    gfmPanel2.add(this.m_HydrCondTextField[n][n2]);
                }
                ++n2;
            }
            this.m_PorosityText[n] = new String(String.valueOf(this.m_Porosity[n]));
            this.m_PorosityTextField[n] = new TextField(15);
            ((TextComponent)this.m_PorosityTextField[n]).setText(this.m_PorosityText[n]);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.m_PorosityTextField[n], gridBagConstraints);
            gfmPanel2.add(this.m_PorosityTextField[n]);
            ++n;
        }
        this.m_Randomize = false;
        this.m_RandomizeCheckbox = new Checkbox("Randomize");
        this.m_RandomizeCheckbox.setState(false);
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagLayout.setConstraints(this.m_RandomizeCheckbox, gridBagConstraints);
        gfmPanel2.add(this.m_RandomizeCheckbox);
        this.add("Center", gfmPanel2);
        this.m_ColorSquare[this.m_SelectedPropertyIndex].Select();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.m_OKButton || event.target instanceof TextField) {
            int n;
            if (this.m_Isotropic) {
                n = 0;
                while (n < this.m_NumProperties) {
                    ((TextComponent)this.m_HydrCondTextField[n][1]).setText(this.m_HydrCondTextField[n][0].getText());
                    ++n;
                }
            }
            n = 0;
            while (n < this.m_NumProperties) {
                double d;
                double d2;
                double d3;
                try {
                    d3 = Double.valueOf(this.m_HydrCondTextField[n][0].getText());
                    d2 = Double.valueOf(this.m_HydrCondTextField[n][1].getText());
                }
                catch (NumberFormatException numberFormatException) {
                    gfmMessageDialog gfmMessageDialog2 = new gfmMessageDialog(this.m_Parent, "Please ensure that all hydraulic conductivity values are positive.");
                    gfmMessageDialog2.show();
                    return true;
                }
                if (d3 <= 0.0 || d2 <= 0.0) {
                    gfmMessageDialog gfmMessageDialog3 = new gfmMessageDialog(this.m_Parent, "Please ensure that all hydraulic conductivity values are positive.");
                    gfmMessageDialog3.show();
                    return true;
                }
                try {
                    d = Double.valueOf(this.m_PorosityTextField[n].getText());
                }
                catch (NumberFormatException numberFormatException) {
                    gfmMessageDialog gfmMessageDialog4 = new gfmMessageDialog(this.m_Parent, "Please ensure that all porosity values are positive.");
                    gfmMessageDialog4.show();
                    return true;
                }
                if (d <= 0.0) {
                    gfmMessageDialog gfmMessageDialog5 = new gfmMessageDialog(this.m_Parent, "Please ensure that all porosity values are positive.");
                    gfmMessageDialog5.show();
                    return true;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.m_NumProperties) {
                int n3 = 0;
                while (n3 < 2) {
                    this.m_HydrCondText[n2][n3] = this.m_HydrCondTextField[n2][n3].getText();
                    this.m_HydrCond[n2][n3] = Double.valueOf(this.m_HydrCondText[n2][n3]);
                    ++n3;
                }
                this.m_PorosityText[n2] = this.m_PorosityTextField[n2].getText();
                this.m_Porosity[n2] = Double.valueOf(this.m_PorosityText[n2]);
                ++n2;
            }
            this.m_SelectedPropertyIndex = this.m_CurrentPropertyIndex;
            this.m_Randomize = this.m_RandomizeCheckbox.getState();
            ((Component)this).hide();
            ((gfmParticleFlowFrame)this.m_Parent).PropertiesDialogCallback(this.m_SelectedPropertyIndex, this.m_Randomize);
        } else if (event.target == this.m_CancelButton) {
            this.UndoChanges();
            ((Component)this).hide();
        }
        return true;
    }

    public void DoModal() {
        this.m_Randomize = false;
        this.m_RandomizeCheckbox.setState(false);
        this.UpdateData();
        super.DoModal();
    }

    protected void UndoChanges() {
        int n = 0;
        while (n < this.m_NumProperties) {
            int n2 = 0;
            while (n2 < 2) {
                ((TextComponent)this.m_HydrCondTextField[n][n2]).setText(this.m_HydrCondText[n][n2]);
                ++n2;
            }
            ((TextComponent)this.m_PorosityTextField[n]).setText(this.m_PorosityText[n]);
            ++n;
        }
        this.m_ColorSquare[this.m_CurrentPropertyIndex].Deselect();
        this.m_ColorSquare[this.m_CurrentPropertyIndex].repaint();
        this.m_CurrentPropertyIndex = this.m_SelectedPropertyIndex;
        this.m_ColorSquare[this.m_SelectedPropertyIndex].Select();
        this.m_ColorSquare[this.m_SelectedPropertyIndex].repaint();
    }

    public void SetCurrentPropertyIndex(int n) {
        this.m_ColorSquare[this.m_CurrentPropertyIndex].Deselect();
        this.m_ColorSquare[this.m_CurrentPropertyIndex].repaint();
        this.m_CurrentPropertyIndex = n;
        this.m_ColorSquare[this.m_CurrentPropertyIndex].Select();
        this.m_ColorSquare[this.m_CurrentPropertyIndex].repaint();
    }

    public void UpdateData() {
        if (this.m_HydrCond != null && this.m_Porosity != null) {
            int n = 0;
            while (n < this.m_NumProperties) {
                int n2 = 0;
                while (n2 < 2) {
                    this.m_HydrCondText[n][n2] = new String(String.valueOf(this.m_HydrCond[n][n2]));
                    ((TextComponent)this.m_HydrCondTextField[n][n2]).setText(this.m_HydrCondText[n][n2]);
                    ++n2;
                }
                this.m_PorosityText[n] = new String(String.valueOf(this.m_Porosity[n]));
                ((TextComponent)this.m_PorosityTextField[n]).setText(this.m_PorosityText[n]);
                ++n;
            }
            this.repaint();
        }
    }
}

