/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class gfmPlotView
extends Canvas {
    protected gfmPlot m_Parent;
    protected double m_XScale;
    protected double m_YScale;
    protected double m_XMax;
    protected double m_XMin;
    protected double m_YMax;
    protected double m_YMin;
    protected double m_XTick;
    protected double m_YTick;
    protected int m_LeftMargin;
    protected int m_RightMargin;
    protected int m_TopMargin;
    protected int m_BottomMargin;
    protected Color[] m_LineColor;
    protected String m_XLabel;
    protected String m_YLabel;
    protected String m_YLabelShort;
    protected FontMetrics m_FontMetrics;
    protected int m_CharHeight;
    protected boolean m_AxesUndefined;
    protected boolean m_FirstPoint = true;
    protected boolean m_MouseDown = false;
    protected int m_xOld;
    protected int m_yOld;
    protected int m_xStart;
    protected int m_yStart;
    protected Graphics m_g;
    protected boolean m_DrawingLine = false;

    public gfmPlotView(gfmPlot gfmPlot2, String string, String string2, String string3, String string4) {
        this.m_Parent = gfmPlot2;
        this.setFont(new Font("Helvetica", 0, 14));
        this.m_FontMetrics = this.getFontMetrics(this.getFont());
        this.m_CharHeight = this.m_FontMetrics.getHeight();
        this.m_XLabel = string2;
        this.m_YLabel = string3;
        this.m_YLabelShort = string4;
        this.m_LeftMargin = this.m_FontMetrics.stringWidth("999999.9") + this.m_FontMetrics.stringWidth(this.m_YLabelShort) + 20;
        this.m_RightMargin = this.m_FontMetrics.stringWidth("999999.9") / 2 + 10;
        this.m_TopMargin = 20;
        this.m_BottomMargin = 2 * this.m_CharHeight + 25;
        this.setBackground(Color.white);
        this.m_LineColor = null;
        this.m_AxesUndefined = true;
    }

    public void AddToPlot() {
        Vector vector = this.m_Parent.GetDataPoints();
        if (vector.size() <= 1) {
            return;
        }
        int n = vector.size();
        double[] dArray = (double[])vector.elementAt(n - 2);
        double[] dArray2 = (double[])vector.elementAt(n - 1);
        int n2 = 1;
        while (n2 < dArray.length) {
            Point point = this.DataToScreen(dArray[0], dArray[n2]);
            Point point2 = this.DataToScreen(dArray2[0], dArray2[n2]);
            Graphics graphics = this.getGraphics();
            if (this.m_LineColor != null && this.m_LineColor.length >= n2) {
                graphics.setColor(this.m_LineColor[n2 - 1]);
            }
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            ++n2;
        }
    }

    protected Point DataToScreen(double[] dArray) {
        int n = (int)((dArray[0] - this.m_XMin) * this.m_XScale + (double)this.m_LeftMargin);
        int n2 = (int)((this.m_YMax - dArray[1]) * this.m_YScale + (double)this.m_TopMargin);
        return new Point(n, n2);
    }

    protected Point DataToScreen(double d, double d2) {
        int n = (int)((d - this.m_XMin) * this.m_XScale + (double)this.m_LeftMargin);
        int n2 = (int)((this.m_YMax - d2) * this.m_YScale + (double)this.m_TopMargin);
        return new Point(n, n2);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.m_AxesUndefined) {
            this.m_g = this.getGraphics();
            this.m_g.setColor(Color.white);
            this.m_g.setXORMode(Color.black);
            this.m_xOld = n;
            this.m_yOld = n2;
            this.m_xStart = n;
            this.m_yStart = n2;
            this.m_DrawingLine = true;
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.m_DrawingLine) {
            this.m_g.drawLine(this.m_xStart, this.m_yStart, this.m_xOld, this.m_yOld);
            this.m_g.drawLine(this.m_xStart, this.m_yStart, n, n2);
            this.m_xOld = n;
            this.m_yOld = n2;
            gfmPoint gfmPoint2 = this.ScreenToData(this.m_xStart, this.m_yStart);
            gfmPoint gfmPoint3 = this.ScreenToData(n, n2);
            double d = (gfmPoint3.yy - gfmPoint2.yy) / (gfmPoint3.xx - gfmPoint2.xx);
            this.m_Parent.SetStatusLineText("Slope = " + String.valueOf(d));
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.m_DrawingLine) {
            this.m_g.drawLine(this.m_xStart, this.m_yStart, n, n2);
            this.m_g.drawLine(this.m_xStart, this.m_yStart, this.m_xStart, this.m_yStart);
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.m_Parent.SetStatusLineText("");
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.m_AxesUndefined) {
            return true;
        }
        gfmPoint gfmPoint2 = this.ScreenToData(n, n2);
        String string = new String();
        if (gfmPoint2.xx >= this.m_XMin && gfmPoint2.yy >= this.m_YMin) {
            double d = gfmMath.RoundTo(gfmPoint2.xx, 4);
            double d2 = gfmMath.RoundTo(gfmPoint2.yy, 4);
            string = "(" + String.valueOf(d) + ", " + String.valueOf(d2) + ")";
        }
        this.m_Parent.SetStatusLineText(string);
        return true;
    }

    public void paint(Graphics graphics) {
        Point point;
        if (this.m_AxesUndefined) {
            graphics.drawString("Please click the \"Set Axes\" button", 50, 100);
            graphics.drawString("to set the axis scales.", 50, 100 + 2 * this.m_CharHeight);
            return;
        }
        Dimension dimension = this.size();
        this.m_XScale = (double)(dimension.width - this.m_LeftMargin - this.m_RightMargin) / (this.m_XMax - this.m_XMin);
        this.m_YScale = (double)(dimension.height - this.m_TopMargin - this.m_BottomMargin) / (this.m_YMax - this.m_YMin);
        Point point2 = this.DataToScreen(this.m_XMin, this.m_YMin);
        Point point3 = this.DataToScreen(this.m_XMax, this.m_YMin);
        graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
        double d = this.m_XMin;
        while (d <= this.m_XMax) {
            String string = Math.abs(d) < 100.0 || Math.abs(d) > 1.0E7 ? Double.toString(d) : Integer.toString((int)d);
            int n = this.m_FontMetrics.stringWidth(string);
            point = this.DataToScreen(d, 0.0);
            graphics.drawString(string, point.x - n / 2, point.y + 10 + this.m_CharHeight);
            graphics.drawLine(point.x, point.y, point.x, point.y + 6);
            d += this.m_XTick;
        }
        point = this.DataToScreen((this.m_XMax + this.m_XMin) / 2.0, 0.0);
        graphics.drawString(this.m_XLabel, point.x - this.m_FontMetrics.stringWidth(this.m_XLabel) / 2, point.y + 15 + this.m_CharHeight * 2);
        point3 = this.DataToScreen(this.m_XMin, this.m_YMax);
        graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
        double d2 = this.m_YMin;
        while (d2 <= this.m_YMax) {
            String string = Math.abs(d2) < 100.0 || Math.abs(d2) > 1.0E7 ? Double.toString(d2) : Integer.toString((int)d2);
            int n = this.m_FontMetrics.stringWidth(string);
            point = this.DataToScreen(0.0, d2);
            graphics.drawString(string, this.m_LeftMargin - n - 10, point.y + this.m_CharHeight / 2);
            graphics.drawLine(this.m_LeftMargin - 6, point.y, this.m_LeftMargin, point.y);
            d2 += this.m_YTick;
        }
        point = this.DataToScreen(0.0, (this.m_YMin + this.m_YMax) / 2.0);
        graphics.drawString(this.m_YLabelShort, 10, point.y + this.m_CharHeight / 2);
        Vector vector = this.m_Parent.GetDataPoints();
        int n = 1;
        while (n < vector.size()) {
            double[] dArray = (double[])vector.elementAt(n - 1);
            double[] dArray2 = (double[])vector.elementAt(n);
            int n2 = dArray.length;
            int n3 = 1;
            while (n3 < n2) {
                point2 = this.DataToScreen(dArray[0], dArray[n3]);
                point3 = this.DataToScreen(dArray2[0], dArray2[n3]);
                if (this.m_LineColor != null && this.m_LineColor.length >= n3) {
                    graphics.setColor(this.m_LineColor[n3 - 1]);
                }
                graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
                ++n3;
            }
            ++n;
        }
    }

    protected gfmPoint ScreenToData(int n, int n2) {
        double d = (double)(n - this.m_LeftMargin) / this.m_XScale + this.m_XMin;
        double d2 = this.m_YMax - (double)(n2 - this.m_TopMargin) / this.m_YScale;
        return new gfmPoint(d, d2);
    }

    public void SetLineColor(Color[] colorArray) {
        this.m_LineColor = colorArray;
    }

    public void SetAxes(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m_XMin = d;
        this.m_XMax = d2;
        this.m_XTick = d3;
        this.m_YMin = d4;
        this.m_YMax = d5;
        this.m_YTick = d6;
        if (this.m_AxesUndefined) {
            this.m_AxesUndefined = false;
        }
    }

    public void SetXLabel(String string) {
        this.m_XLabel = string;
    }

    public void SetYLabel(String string, String string2) {
        this.m_YLabel = string;
        this.m_YLabelShort = string2;
    }
}

