/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;

public class gfmParticleFlowFrame
extends gfmFrame
implements Runnable {
    protected Thread m_SolutionThread;
    protected Thread m_AnimationThread;
    protected Button m_StartButton;
    protected Button m_PropertiesButton;
    protected Button m_HeadButton;
    protected Button m_FlowButton;
    protected Button m_AnimationButton;
    protected gfmStartDialog m_StartDialog;
    protected gfmPropertiesDialog m_PropertiesDialog;
    protected gfmHeadDialog m_HeadDialog;
    protected gfmFlowDialog m_FlowDialog;
    protected gfmAnimationDialog m_AnimationDialog;
    protected gfmMessageDialog m_UnableToTrackDialog;
    protected Label m_TimeLabel;
    protected Label m_LocalDispersionLabel;
    protected double m_ModelDomainLength;
    protected double m_ModelDomainWidth;
    protected double m_GridSpacing;
    public static final int NULL_STEP = 0;
    public static final int START_STEP = 1;
    public static final int PROPERTIES_STEP = 2;
    public static final int HEAD_STEP = 3;
    public static final int FLOW_STEP = 4;
    public static final int ANIMATION_STEP = 5;
    public static final int FLOW_PATH_OPTION = 0;
    public static final int PARTICLE_OPTION = 1;
    public static final int TIME_IN_DAYS = 0;
    public static final int TIME_IN_YEARS = 1;
    protected gfmParticleFlowMesh m_Mesh;
    protected gfmHeadModel m_HeadModel;
    protected gfmStreamFunctionModel m_StreamFunctionModel;
    protected gfmFlowObject m_FlowObject;
    protected gfmFlowPaths m_FlowPaths;
    protected gfmParticleCloud m_ParticleCloud;
    protected gfmPlot m_VariancePlot;
    protected double m_AverageHydraulicGradient;
    protected final int m_NumProperties = 5;
    protected Color[] m_PropertyColor = new Color[]{new Color(0.85f, 1.0f, 1.0f), new Color(0.85f, 1.0f, 0.85f), Color.white, new Color(1.0f, 1.0f, 0.85f), new Color(1.0f, 0.85f, 0.85f)};
    protected double[][] m_HydrCond = new double[][]{{0.004, 0.004}, {0.002, 0.002}, {0.001, 0.001}, {5.0E-4, 5.0E-4}, {2.5E-4, 2.5E-4}};
    protected double[] m_Porosity = new double[]{20.0, 20.0, 20.0, 20.0, 20.0};
    protected int[] m_PropertyIndex;
    protected int m_SelectedPropertyIndex = 2;
    protected int m_NumContour = 20;
    protected int m_TrackDirection;
    protected double m_ParticleSpacing;
    protected int m_FlowOption = 0;
    private gfmNodeValue m_Dummy1;
    private gfmNodes m_Dummy2;
    protected boolean m_Startup;
    protected boolean m_AnimationIsFrozen = false;
    protected int m_MillisecPerFrame = 100;
    protected double m_TravelTime;
    protected double m_TravelTimeInSec;
    protected double m_TravelTimePerFrame = 1.0;
    protected int m_TimeUnitIndex = 0;
    protected double m_ConversionToSec = 86400.0;
    protected static final String[] m_TimeUnit = new String[]{new String("days"), new String("years")};
    protected int m_CompletedStep;

    public gfmParticleFlowFrame(gfmPlot gfmPlot2) {
        this.setTitle("Particle Transport in Steady-State Flow Field");
        this.m_VariancePlot = gfmPlot2;
        this.m_CompletedStep = 0;
        this.m_StartDialog = new gfmStartDialog(this);
        this.m_PropertiesDialog = new gfmPropertiesDialog(this, this.m_PropertyColor, this.m_HydrCond, this.m_Porosity, 5, this.m_SelectedPropertyIndex, true);
        this.m_HeadDialog = new gfmHeadDialog(this);
        this.m_FlowDialog = new gfmFlowDialog(this);
        this.m_AnimationDialog = new gfmAnimationDialog(this);
        this.m_UnableToTrackDialog = new gfmMessageDialog((Frame)this, "Sorry, unable to track flowpath from selected point.");
        this.m_Mesh = new gfmParticleFlowMesh();
        this.m_HeadModel = new gfmHeadModel();
        this.m_StreamFunctionModel = new gfmStreamFunctionModel();
        this.m_ParticleCloud = new gfmParticleCloud(this, this.m_VariancePlot);
        this.m_FlowPaths = new gfmFlowPaths(this);
        this.m_FlowObject = this.m_FlowPaths;
        new gfmNodeValue();
        new gfmNodes();
    }

    public void AnimationDialogCallback(double d, int n, int n2, double d2, double d3, boolean bl, int n3, boolean bl2) {
        this.m_TimeUnitIndex = n;
        this.m_TravelTimePerFrame = d / (double)n2;
        this.m_MillisecPerFrame = n2 > 0 ? 1000 / n2 : 100;
        this.m_ConversionToSec = n == 0 ? 86400.0 : 3.1536E7;
        this.m_ParticleCloud.SetDispersivities(d2, d3);
        this.m_ParticleCloud.ShowMoments(bl);
        this.m_ParticleCloud.SetNumberOfStandardDeviations(n3);
        this.m_ParticleCloud.SetMakePlot(bl2);
        this.m_ParticleCloud.SetTimeUnit(n);
        this.m_ParticleCloud.SetTimeStepInSec(this.m_TravelTimePerFrame * this.m_ConversionToSec);
        if (n == 0) {
            this.m_VariancePlot.SetXLabel("Time in days");
        } else if (n == 1) {
            this.m_VariancePlot.SetXLabel("Time in years");
        }
        this.m_View.EnableDrawingPolygon(false);
        this.m_View.EnableDrawingPoint(false);
        this.m_FlowObject.InitAnimation();
        this.m_AnimationIsFrozen = true;
        this.m_TravelTime = 0.0;
        this.m_TravelTimeInSec = 0.0;
        if (this.m_FlowObject instanceof gfmFlowPaths) {
            this.m_LocalDispersionLabel.setText("");
        } else if (d2 > 0.0 || d3 > 0.0) {
            this.m_LocalDispersionLabel.setText("Local Dispersion On");
        } else {
            this.m_LocalDispersionLabel.setText("Local Dispersion Off");
        }
        this.m_CompletedStep = 5;
        this.m_View.DrawScene();
        this.m_TimeLabel.setText("Time = 0 " + m_TimeUnit[this.m_TimeUnitIndex]);
    }

    protected void CreateStatusBarItems(Panel panel) {
        super.CreateStatusBarItems(panel);
        this.m_TimeLabel = new Label("", 1);
        this.m_LocalDispersionLabel = new Label("", 2);
        panel.add(this.m_TimeLabel);
        panel.add(this.m_LocalDispersionLabel);
    }

    protected void CreateModelButtons(Panel panel) {
        this.m_StartButton = new Button("Start");
        this.m_PropertiesButton = new Button("Properties");
        this.m_HeadButton = new Button("Head");
        this.m_FlowButton = new Button("Flow");
        this.m_AnimationButton = new Button("Animation");
        panel.add(this.m_StartButton);
        panel.add(this.m_PropertiesButton);
        panel.add(this.m_HeadButton);
        panel.add(this.m_FlowButton);
        panel.add(this.m_AnimationButton);
        this.EnableModelButtons(true, false, false, false, false);
    }

    protected void CreateView() {
        this.m_View = new gfmParticleFlowView(this);
        this.m_OptionsButton.hide();
    }

    protected void EnableModelButtons(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (bl) {
            this.m_StartButton.enable();
        } else {
            this.m_StartButton.disable();
        }
        if (bl2) {
            this.m_PropertiesButton.enable();
        } else {
            this.m_PropertiesButton.disable();
        }
        if (bl3) {
            this.m_HeadButton.enable();
        } else {
            this.m_HeadButton.disable();
        }
        if (bl4) {
            this.m_FlowButton.enable();
        } else {
            this.m_FlowButton.disable();
        }
        if (bl5) {
            this.m_AnimationButton.enable();
            return;
        }
        this.m_AnimationButton.disable();
    }

    public void FlowDialogCallback(int n, double d, int n2, boolean bl) {
        this.m_FlowOption = n2;
        this.m_CompletedStep = 4;
        if (n2 == 0) {
            this.m_TrackDirection = n;
            this.m_FlowObject = this.m_FlowPaths;
            this.m_ParticleCloud.Clear();
            this.m_FlowPaths.Clear();
            this.EnableModelButtons(true, true, true, true, false);
            this.m_View.EnableDrawingPoint(true);
        } else {
            this.m_ParticleSpacing = d;
            this.m_FlowObject = this.m_ParticleCloud;
            this.m_FlowPaths.Clear();
            if (bl) {
                this.m_ParticleCloud.RestartParticles();
                if (this.m_ParticleCloud.GetCount() > 0) {
                    this.EnableModelButtons(true, true, true, true, true);
                } else {
                    this.EnableModelButtons(true, true, true, true, false);
                }
            } else {
                this.m_ParticleCloud.Clear();
                this.EnableModelButtons(true, true, true, true, false);
            }
            this.m_View.EnableDrawingPolygon(true);
        }
        this.m_View.DrawScene();
        this.m_View.ShowCoordinates(true);
        this.m_TimeLabel.setText("");
        this.m_LocalDispersionLabel.setText("");
        this.m_ParticleCloud.HidePlot();
    }

    public int GetCompletedStep() {
        return this.m_CompletedStep;
    }

    public gfmFlowObject GetFlowObject() {
        return this.m_FlowObject;
    }

    public double GetGridSpacing() {
        return this.m_GridSpacing;
    }

    public gfmHeadModel GetHeadModel() {
        return this.m_HeadModel;
    }

    public double GetModelDomainLength() {
        return this.m_ModelDomainLength;
    }

    public double GetModelDomainWidth() {
        return this.m_ModelDomainWidth;
    }

    public double GetTravelTimeInSec() {
        return this.m_TravelTimeInSec;
    }

    protected void HandleModelButtons(Event event, Object object) {
        if (event.target.equals(this.m_StartButton)) {
            if (this.m_View.IsDrawing() || this.m_IsBusy) {
                return;
            }
            this.m_StartDialog.DoModal();
            return;
        }
        if (event.target.equals(this.m_PropertiesButton)) {
            if (this.m_View.IsDrawing() || this.m_CompletedStep < 1 || this.m_IsBusy) {
                return;
            }
            this.m_PropertiesDialog.DoModal();
            return;
        }
        if (event.target.equals(this.m_HeadButton)) {
            if (this.m_View.IsDrawing() || this.m_CompletedStep < 2 || this.m_IsBusy) {
                return;
            }
            this.m_HeadDialog.DoModal();
            return;
        }
        if (event.target.equals(this.m_FlowButton)) {
            if (this.m_View.IsDrawing() || this.m_CompletedStep < 3 || this.m_IsBusy) {
                return;
            }
            this.m_FlowDialog.DoModal();
            return;
        }
        if (event.target.equals(this.m_AnimationButton)) {
            if (this.m_View.IsDrawing() || this.m_CompletedStep < 4 || this.m_IsBusy) {
                return;
            }
            this.m_AnimationDialog.DoModal();
        }
    }

    public void HeadDialogCallback(int n) {
        this.m_NumContour = n;
        this.m_ParticleCloud.HidePlot();
        this.m_View.EnableDrawingPoint(false);
        this.m_View.EnableDrawingPolygon(false);
        this.m_View.ShowCoordinates(true);
        this.m_TimeLabel.setText("");
        this.m_LocalDispersionLabel.setText("");
        this.m_SolutionThread = new Thread(this);
        this.m_SolutionThread.start();
    }

    protected void OnExit() {
        if (this.m_InAnApplet) {
            this.dispose();
            this.m_VariancePlot.dispose();
            return;
        }
        System.exit(0);
    }

    protected void OnFinishedDrawingPoint(double d, double d2) {
        if (this.m_CompletedStep == 4) {
            if (d < 0.0 || d > this.m_ModelDomainLength || d2 < 0.0 || d2 > this.m_ModelDomainWidth) {
                return;
            }
            int n = this.m_Mesh.GetNumberOfNodes();
            if (this.m_FlowPaths.Track(d, d2, this.m_TrackDirection, n)) {
                this.m_View.AddToScene();
                this.EnableModelButtons(true, true, true, true, true);
            } else {
                this.m_UnableToTrackDialog.show();
            }
            this.m_View.EnableDrawingPoint(true);
        }
    }

    public void OnFinishedDrawingPolygon(gfmPolygon gfmPolygon2) {
        if (this.m_CompletedStep == 2) {
            this.m_HeadModel.SetPropertyZone(gfmPolygon2, this.m_SelectedPropertyIndex);
            this.m_View.DrawScene();
            this.m_View.EnableDrawingPolygon(true);
            return;
        }
        if (this.m_CompletedStep == 4 && this.m_FlowOption == 1) {
            this.m_IsBusy = true;
            this.setCursor(3);
            this.m_ProgramStatusLabel.setText("Computing. Please Wait.");
            this.m_ParticleCloud.MakeParticles(gfmPolygon2, this.m_ParticleSpacing);
            this.m_View.AddToScene();
            if (this.m_ParticleCloud.GetCount() > 0) {
                this.EnableModelButtons(true, true, true, true, true);
            }
            this.m_View.EnableDrawingPolygon(true);
            this.m_IsBusy = false;
            this.setCursor(0);
            this.m_ProgramStatusLabel.setText("Ready");
        }
    }

    public void PropertiesDialogCallback(int n, boolean bl) {
        if (!bl) {
            this.m_SelectedPropertyIndex = n;
            if (this.m_CompletedStep > 2) {
                this.m_CompletedStep = 2;
                this.m_View.DrawScene();
            } else {
                this.m_CompletedStep = 2;
            }
            this.m_View.EnableDrawingPolygon(true);
        } else {
            int n2 = this.m_Mesh.GetNumberOfElements();
            int[] nArray = this.m_HeadModel.GetPropertyIndex();
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                nArray[n3] = n4 = (int)(Math.random() * 5.0);
                nArray[n3 + 1] = n4;
                n3 += 2;
            }
            this.m_CompletedStep = 2;
            this.m_View.DrawScene();
        }
        this.m_View.ShowCoordinates(true);
        this.m_TimeLabel.setText("");
        this.m_LocalDispersionLabel.setText("");
        this.EnableModelButtons(true, true, true, false, false);
        this.m_ParticleCloud.HidePlot();
    }

    public void run() {
        if (Thread.currentThread() == this.m_SolutionThread) {
            this.m_IsBusy = true;
            this.setCursor(3);
            this.m_View.ShowCoordinates(false);
            this.m_ProgramStatusLabel.setText("Computing. Please Wait.");
            this.m_HeadModel.Solve();
            this.m_HeadModel.MakeNContours(this.m_NumContour);
            this.m_HeadModel.ComputeFlux();
            double[][] dArray = this.m_HeadModel.GetFlux();
            int n = this.m_Mesh.GetNumberOfColumns();
            int n2 = this.m_Mesh.GetNumberOfRows();
            gfmNodeValue[] gfmNodeValueArray = new gfmNodeValue[2 * (n + n2)];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n + 1) {
                gfmNodeValueArray[n3] = new gfmNodeValue(n4 * (n2 + 1), 0.0);
                ++n3;
                ++n4;
            }
            double d = 0.0;
            n4 = 0;
            while (n4 < n2) {
                gfmNodeValueArray[n3] = new gfmNodeValue(n4 + 1, d -= dArray[2 * n4 + 1][0] * this.m_GridSpacing);
                ++n3;
                ++n4;
            }
            double d2 = 0.0;
            int n5 = (n2 + 1) * n + 1;
            int n6 = 2 * n2 * (n - 1);
            n4 = 0;
            while (n4 < n2) {
                gfmNodeValueArray[n3] = new gfmNodeValue(n5 + n4, d2 -= dArray[n6 + 2 * n4][0] * this.m_GridSpacing);
                ++n3;
                ++n4;
            }
            double d3 = (d + d2) / 2.0;
            n4 = 1;
            while (n4 < n) {
                gfmNodeValueArray[n3] = new gfmNodeValue(n4 * (n2 + 1) + n2, d3);
                ++n3;
                ++n4;
            }
            this.m_StreamFunctionModel.SetBoundaryValue(2 * (n + n2), gfmNodeValueArray);
            this.m_StreamFunctionModel.SetBoundaryFlux(0, null);
            this.m_StreamFunctionModel.Solve();
            this.m_StreamFunctionModel.ComputeVelocity();
            this.m_FlowPaths.SetVelocityDirection(this.m_StreamFunctionModel.GetVelocityDirection());
            this.m_FlowPaths.SetVelocityMagnitude(this.m_StreamFunctionModel.GetVelocityMagnitude());
            this.m_ParticleCloud.SetVelocityDirection(this.m_StreamFunctionModel.GetVelocityDirection());
            this.m_ParticleCloud.SetVelocityMagnitude(this.m_StreamFunctionModel.GetVelocityMagnitude());
            this.m_FlowPaths.SetStreamFunction(this.m_StreamFunctionModel.GetValues());
            this.m_ParticleCloud.SetStreamFunction(this.m_StreamFunctionModel.GetValues());
            this.m_CompletedStep = 3;
            this.m_View.DrawScene();
            this.m_IsBusy = false;
            this.setCursor(0);
            this.m_View.ShowCoordinates(true);
            this.m_ProgramStatusLabel.setText("Ready");
            this.EnableModelButtons(true, true, true, true, false);
            return;
        }
        if (Thread.currentThread() == this.m_AnimationThread) {
            this.m_IsBusy = true;
            this.m_View.ShowCoordinates(false);
            this.m_ProgramStatusLabel.setText("Animating");
            while (this.m_FlowObject.GetActiveCount() > 0 && Thread.currentThread() == this.m_AnimationThread) {
                long l = System.currentTimeMillis();
                this.m_TravelTime += this.m_TravelTimePerFrame;
                this.m_TravelTimeInSec = this.m_TravelTime * this.m_ConversionToSec;
                this.m_TimeLabel.setText("Time = " + String.valueOf(this.m_TravelTime) + " " + m_TimeUnit[this.m_TimeUnitIndex]);
                this.m_View.AddToScene();
                long l2 = l + (long)this.m_MillisecPerFrame - System.currentTimeMillis();
                if (l2 <= 0L) continue;
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_ProgramStatusLabel.setText("Ready");
            this.m_View.ShowCoordinates(true);
            this.m_IsBusy = false;
        }
    }

    protected void SetUpModel(int n, int n2) {
        int n3 = (n + 1) * (n2 + 1);
        int n4 = 2 * n * n2;
        gfmNodes gfmNodes2 = new gfmNodes();
        int n5 = 0;
        while (n5 < n + 1) {
            double d = (double)n5 * this.m_GridSpacing;
            int n6 = 0;
            while (n6 < n2 + 1) {
                double d2 = (double)n6 * this.m_GridSpacing;
                gfmNodes2.AddNode(d, d2);
                ++n6;
            }
            ++n5;
        }
        this.m_Mesh.SetNodes(gfmNodes2);
        this.m_Mesh.SetDimensions(n, n2);
        this.m_PropertyIndex = new int[n4];
        n5 = 0;
        while (n5 < n4) {
            this.m_PropertyIndex[n5] = 2;
            ++n5;
        }
        this.m_HeadModel.Clear();
        this.m_HeadModel.SetMesh(this.m_Mesh);
        this.m_HeadModel.SetPropertyColor(this.m_PropertyColor);
        this.m_HeadModel.SetPropertyIndex(this.m_PropertyIndex);
        this.m_HeadModel.SetConductivity(this.m_HydrCond);
        gfmNodeValue[] gfmNodeValueArray = new gfmNodeValue[2 * (n2 + 1)];
        double d = this.m_AverageHydraulicGradient * this.m_ModelDomainLength;
        n5 = 0;
        while (n5 < n2 + 1) {
            gfmNodeValueArray[n5] = new gfmNodeValue(n5, d);
            gfmNodeValueArray[n2 + 1 + n5] = new gfmNodeValue(n3 - 1 - n5, 0.0);
            ++n5;
        }
        this.m_HeadModel.SetBoundaryValue(2 * (n2 + 1), gfmNodeValueArray);
        this.m_HeadModel.SetBoundaryFlux(0, null);
        this.m_StreamFunctionModel.Clear();
        this.m_StreamFunctionModel.SetMesh(this.m_Mesh);
        this.m_StreamFunctionModel.SetPropertyColor(this.m_PropertyColor);
        this.m_StreamFunctionModel.SetPropertyIndex(this.m_PropertyIndex);
        this.m_StreamFunctionModel.SetConductivity(this.m_HydrCond);
        this.m_StreamFunctionModel.SetPorosity(this.m_Porosity);
        this.m_FlowPaths.SetMesh(this.m_Mesh);
        this.m_ParticleCloud.SetMesh(this.m_Mesh);
    }

    public void StartDialogCallback(double d, int n, int n2, double d2) {
        this.m_GridSpacing = d;
        this.m_ModelDomainLength = d * (double)n;
        this.m_ModelDomainWidth = d * (double)n2;
        this.m_AverageHydraulicGradient = d2;
        int n3 = (int)((double)(this.m_View.GetSceneWidth() - 2 * this.m_View.GetMDOx()) * this.m_ModelDomainWidth / this.m_ModelDomainLength + (double)(2 * this.m_View.GetMDOx()));
        this.m_View.SetSceneHeight(n3);
        this.m_View.SetScale(this.m_ModelDomainLength, 1.0);
        this.SetUpModel(n, n2);
        this.m_CompletedStep = 1;
        this.m_View.ShowCoordinates(true);
        this.m_TimeLabel.setText("");
        this.m_LocalDispersionLabel.setText("");
        this.m_View.DrawBackground();
        this.m_View.DrawScene();
        this.m_ParticleCloud.HidePlot();
        this.EnableModelButtons(true, true, false, false, false);
    }

    protected void ToggleAnimation() {
        if (this.m_CompletedStep == 5) {
            if (this.m_AnimationIsFrozen) {
                this.m_AnimationIsFrozen = false;
                this.m_AnimationThread = new Thread(this);
                this.m_AnimationThread.start();
                this.m_IsBusy = true;
                return;
            }
            this.m_AnimationIsFrozen = true;
            this.m_AnimationThread = null;
            this.m_IsBusy = false;
        }
    }

    public static void main(String[] stringArray) {
        gfmPlot gfmPlot2 = new gfmPlot("Spatial Variance versus Time", "Time in days ", "Variance in m*m", "Var (m*m)");
        gfmParticleFlowFrame gfmParticleFlowFrame2 = new gfmParticleFlowFrame(gfmPlot2);
        gfmParticleFlowFrame2.m_InAnApplet = false;
        gfmParticleFlowFrame2.pack();
        Dimension dimension = gfmParticleFlowFrame2.size();
        Dimension dimension2 = gfmParticleFlowFrame2.getToolkit().getScreenSize();
        gfmParticleFlowFrame2.move((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        gfmParticleFlowFrame2.show();
    }
}

