/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;

class gfmParticleCloud
extends gfmFlowObject {
    protected Vector m_ParticleCloud = new Vector();
    protected gfmMoment12 m_Moment12;
    protected double m_LongitudinalDispersivity;
    protected double m_TransverseDispersivity;
    protected double m_TimeStepInSec;
    protected double m_ModelDomainLength;
    protected double m_ModelDomainWidth;
    protected double m_GridSpacing;
    protected double m_Offset;
    protected double m_TimeConversionFactor = 1.0;
    protected double m_TwoDtLong;
    protected double m_TwoDtTrans;
    protected int m_NumColumn;
    protected int m_NumRow;
    protected boolean m_ShowMoments;
    protected boolean m_MakePlot;
    protected gfmPlot m_VariancePlot;

    public gfmParticleCloud(gfmParticleFlowFrame gfmParticleFlowFrame2, gfmPlot gfmPlot2) {
        super(gfmParticleFlowFrame2);
        Color[] colorArray = new Color[]{Color.blue, Color.green};
        this.m_Moment12 = new gfmMoment12(gfmParticleFlowFrame2);
        this.m_Moment12.SetColor(colorArray);
        this.m_LongitudinalDispersivity = 0.0;
        this.m_TransverseDispersivity = 0.0;
        this.m_ShowMoments = false;
        this.m_VariancePlot = gfmPlot2;
        ((Component)this.m_VariancePlot).reshape(0, 0, 400, 300);
        this.m_VariancePlot.SetLineColor(colorArray);
    }

    public void Animate(double d, Graphics graphics, gfmView gfmView2, Color color) {
        Object object;
        graphics.setColor(color);
        this.m_Moment12.Clear();
        int n = 0;
        while (n < this.m_ParticleCloud.size()) {
            object = (gfmParticle)this.m_ParticleCloud.elementAt(n);
            if (((gfmParticle)object).IsActive) {
                while (d > ((gfmParticle)object).ElementExitTime && ((gfmParticle)object).IsActive) {
                    if (((gfmParticle)object).NextElementId == -1) {
                        ((gfmParticle)object).IsActive = false;
                        --this.m_ActiveCount;
                        continue;
                    }
                    ((gfmParticle)object).ElementId = ((gfmParticle)object).NextElementId;
                    ((gfmParticle)object).ElementEntryPoint.xx = ((gfmParticle)object).ElementExitPoint.xx;
                    ((gfmParticle)object).ElementEntryPoint.yy = ((gfmParticle)object).ElementExitPoint.yy;
                    ((gfmParticle)object).ElementEntryTime = ((gfmParticle)object).ElementExitTime;
                    this.ComputeElementExit((gfmParticle)object);
                    ((gfmParticle)object).ElementExitTime += gfmMath.DistanceBetweenTwoPoints(((gfmParticle)object).ElementEntryPoint, ((gfmParticle)object).ElementExitPoint) / this.m_VelocityMagnitude[((gfmParticle)object).ElementId];
                }
                if (((gfmParticle)object).IsActive) {
                    double d2 = (d - ((gfmParticle)object).ElementEntryTime) / (((gfmParticle)object).ElementExitTime - ((gfmParticle)object).ElementEntryTime);
                    double d3 = ((gfmParticle)object).ElementEntryPoint.xx + d2 * (((gfmParticle)object).ElementExitPoint.xx - ((gfmParticle)object).ElementEntryPoint.xx);
                    double d4 = ((gfmParticle)object).ElementEntryPoint.yy + d2 * (((gfmParticle)object).ElementExitPoint.yy - ((gfmParticle)object).ElementEntryPoint.yy);
                    if (this.m_LongitudinalDispersivity > 0.0 || this.m_TransverseDispersivity > 0.0) {
                        double d5 = Math.sqrt(this.m_TwoDtLong * this.m_VelocityMagnitude[((gfmParticle)object).ElementId]) * gfmMath.NormalDeviate();
                        double d6 = Math.sqrt(this.m_TwoDtTrans * this.m_VelocityMagnitude[((gfmParticle)object).ElementId]) * gfmMath.NormalDeviate();
                        double[] dArray = this.m_VelocityDirection[((gfmParticle)object).ElementId];
                        d3 += d5 * dArray[0] - d6 * dArray[1];
                        d4 += d5 * dArray[1] + d6 * dArray[0];
                        if (d3 >= this.m_ModelDomainLength) {
                            ((gfmParticle)object).IsActive = false;
                            --this.m_ActiveCount;
                        } else {
                            if (d3 <= 0.0) {
                                d3 = this.m_Offset;
                            }
                            if (d4 <= 0.0) {
                                d4 = this.m_Offset;
                            }
                            if (d4 >= this.m_ModelDomainWidth) {
                                d4 = this.m_ModelDomainWidth - this.m_Offset;
                            }
                            int n2 = (int)(d3 / this.m_GridSpacing);
                            int n3 = (int)(d4 / this.m_GridSpacing);
                            int n4 = 2 * (n2 * this.m_NumRow + n3);
                            if (d4 - (double)n3 * this.m_GridSpacing > d3 - (double)n2 * this.m_GridSpacing) {
                                ++n4;
                            }
                            double[] dArray2 = new double[8];
                            double[] dArray3 = new double[]{d3, d4};
                            this.m_Mesh.GetElement(n4).EvaluatePosition(dArray3, dArray2);
                            int[] nArray = this.m_Mesh.GetNodeIdsOfElement(n4);
                            double d7 = 0.0;
                            n3 = 0;
                            while (n3 < this.m_Mesh.GetElement(n4).GetNumberOfNodes()) {
                                d7 += this.m_StreamFunction[nArray[n3]] * dArray2[n3];
                                ++n3;
                            }
                            ((gfmParticle)object).Position.xx = d3;
                            ((gfmParticle)object).Position.yy = d4;
                            ((gfmParticle)object).ElementId = n4;
                            ((gfmParticle)object).StreamFunctionValue = d7;
                            ((gfmParticle)object).ElementEntryPoint.xx = d3;
                            ((gfmParticle)object).ElementEntryPoint.yy = d4;
                            ((gfmParticle)object).ElementEntryTime = d;
                            this.ComputeElementExit((gfmParticle)object);
                            if (((gfmParticle)object).IsActive) {
                                ((gfmParticle)object).ElementExitTime = ((gfmParticle)object).ElementEntryTime + gfmMath.DistanceBetweenTwoPoints(((gfmParticle)object).ElementEntryPoint, ((gfmParticle)object).ElementExitPoint) / this.m_VelocityMagnitude[((gfmParticle)object).ElementId];
                                ((gfmParticle)object).Position.Draw(graphics, gfmView2);
                                this.m_Moment12.AddPoint(d3, d4);
                            }
                        }
                    } else {
                        ((gfmParticle)object).Position.xx = d3;
                        ((gfmParticle)object).Position.yy = d4;
                        ((gfmParticle)object).Position.Draw(graphics, gfmView2);
                        this.m_Moment12.AddPoint(d3, d4);
                    }
                }
            }
            ++n;
        }
        if ((double)(this.m_ActiveCount / this.m_ParticleCloud.size()) > 0.9) {
            this.m_Moment12.Compute();
            if (this.m_ShowMoments) {
                this.m_Moment12.Draw(graphics, gfmView2);
            }
            if (this.m_MakePlot) {
                object = this.m_Moment12.GetStandardDeviation();
                double[] dArray = new double[]{d * this.m_TimeConversionFactor, (double)(object[0] * object[0]), (double)(object[1] * object[1])};
                this.m_VariancePlot.AddPointAndDraw(dArray);
            }
        }
    }

    public void Clear() {
        this.m_ParticleCloud.removeAllElements();
    }

    protected void ComputeElementExit(gfmParticle gfmParticle2) {
        gfmIdList gfmIdList2;
        if (!gfmParticle2.IsActive) {
            return;
        }
        gfmLine gfmLine2 = new gfmLine();
        int[] nArray = new int[4];
        boolean bl = this.m_Mesh.GetElement(gfmParticle2.ElementId).MakeContourPrimitive(gfmParticle2.StreamFunctionValue, this.m_StreamFunction, gfmLine2, nArray);
        if (!bl) {
            gfmParticle2.IsActive = false;
            return;
        }
        double d = gfmLine2.x2 - gfmLine2.x1;
        double d2 = gfmLine2.y2 - gfmLine2.y1;
        gfmIdList gfmIdList3 = new gfmIdList();
        double d3 = d * this.m_VelocityDirection[gfmParticle2.ElementId][0] + d2 * this.m_VelocityDirection[gfmParticle2.ElementId][1];
        if (d3 > 0.0) {
            gfmParticle2.ElementExitPoint.xx = gfmLine2.x2;
            gfmParticle2.ElementExitPoint.yy = gfmLine2.y2;
            gfmIdList3.AddId(nArray[2]);
            if (nArray[3] != nArray[2]) {
                gfmIdList3.AddId(nArray[3]);
            }
        } else {
            gfmParticle2.ElementExitPoint.xx = gfmLine2.x1;
            gfmParticle2.ElementExitPoint.yy = gfmLine2.y1;
            gfmIdList3.AddId(nArray[0]);
            if (nArray[1] != nArray[0]) {
                gfmIdList3.AddId(nArray[1]);
            }
        }
        if ((gfmIdList2 = this.m_Mesh.GetNeighborsUsingNodes(gfmParticle2.ElementId, gfmIdList3)).GetNumberOfIds() > 0) {
            int n = 0;
            while (n < gfmIdList2.GetNumberOfIds()) {
                int n2 = gfmIdList2.GetId(n);
                if (this.m_Mesh.GetElement(n2).MakeContourPrimitive(gfmParticle2.StreamFunctionValue, this.m_StreamFunction, gfmLine2, nArray)) {
                    gfmParticle2.NextElementId = n2;
                    return;
                }
                ++n;
            }
            return;
        }
        gfmParticle2.NextElementId = -1;
    }

    public void Draw(Graphics graphics, gfmView gfmView2, Color color) {
        graphics.setColor(color);
        int n = 0;
        while (n < this.m_ParticleCloud.size()) {
            gfmParticle gfmParticle2 = (gfmParticle)this.m_ParticleCloud.elementAt(n);
            if (gfmParticle2.IsActive) {
                gfmParticle2.Position.Draw(graphics, gfmView2);
            }
            ++n;
        }
        if (this.m_ShowMoments && this.m_ParticleCloud.size() > 0 && this.m_FrameParent.GetCompletedStep() == 5 && (double)(this.m_ActiveCount / this.m_ParticleCloud.size()) > 0.9) {
            this.m_Moment12.Draw(graphics, gfmView2);
        }
    }

    public int GetCount() {
        return this.m_ParticleCloud.size();
    }

    public void HidePlot() {
        ((Component)this.m_VariancePlot).hide();
    }

    public void InitAnimation() {
        Object object;
        this.m_Moment12.Clear();
        this.m_VariancePlot.Clear();
        this.m_ActiveCount = this.m_ParticleCloud.size();
        this.m_TwoDtLong = 2.0 * this.m_LongitudinalDispersivity * this.m_TimeStepInSec;
        this.m_TwoDtTrans = 2.0 * this.m_TransverseDispersivity * this.m_TimeStepInSec;
        int n = 0;
        while (n < this.m_ParticleCloud.size()) {
            object = (gfmParticle)this.m_ParticleCloud.elementAt(n);
            ((gfmParticle)object).IsActive = true;
            ((gfmParticle)object).Position.xx = ((gfmParticle)object).StartingPosition.xx;
            ((gfmParticle)object).Position.yy = ((gfmParticle)object).StartingPosition.yy;
            ((gfmParticle)object).ElementId = ((gfmParticle)object).StartingElementId;
            ((gfmParticle)object).ElementEntryTime = 0.0;
            ((gfmParticle)object).ElementEntryPoint.xx = ((gfmParticle)object).StartingPosition.xx;
            ((gfmParticle)object).ElementEntryPoint.yy = ((gfmParticle)object).StartingPosition.yy;
            this.ComputeElementExit((gfmParticle)object);
            ((gfmParticle)object).ElementExitTime = gfmMath.DistanceBetweenTwoPoints(((gfmParticle)object).StartingPosition, ((gfmParticle)object).ElementExitPoint) / this.m_VelocityMagnitude[((gfmParticle)object).ElementId];
            this.m_Moment12.AddPoint(((gfmParticle)object).Position);
            ++n;
        }
        if (this.m_ParticleCloud.size() > 0) {
            this.m_Moment12.Compute();
            if (this.m_MakePlot) {
                this.m_VariancePlot.show();
                object = this.m_Moment12.GetStandardDeviation();
                double[] dArray = new double[]{0.0, (double)(object[0] * object[0]), (double)(object[1] * object[1])};
                this.m_VariancePlot.AddPoint(dArray);
            }
        }
    }

    public void MakeParticles(gfmPolygon gfmPolygon2, double d) {
        this.m_ModelDomainLength = this.m_FrameParent.GetModelDomainLength();
        this.m_ModelDomainWidth = this.m_FrameParent.GetModelDomainWidth();
        this.m_GridSpacing = this.m_FrameParent.GetGridSpacing();
        this.m_Offset = this.m_GridSpacing / 100.0;
        this.m_NumColumn = this.m_Mesh.GetNumberOfColumns();
        this.m_NumRow = this.m_Mesh.GetNumberOfRows();
        this.m_Moment12.Clear();
        gfmRectangle gfmRectangle2 = gfmPolygon2.GetBoundingBox();
        if (gfmRectangle2.xMin < 0.0) {
            gfmRectangle2.xMin = 0.0;
        }
        if (gfmRectangle2.xMax > this.m_ModelDomainLength) {
            gfmRectangle2.xMax = this.m_ModelDomainLength;
        }
        if (gfmRectangle2.yMin < 0.0) {
            gfmRectangle2.yMin = 0.0;
        }
        if (gfmRectangle2.yMax > this.m_ModelDomainWidth) {
            gfmRectangle2.yMax = this.m_ModelDomainWidth;
        }
        double d2 = gfmRectangle2.xMin;
        while (d2 <= gfmRectangle2.xMax) {
            double d3 = d2;
            if (d3 == (double)((int)(d3 / this.m_GridSpacing)) * this.m_GridSpacing) {
                d3 = d3 + this.m_Offset >= this.m_ModelDomainLength ? (d3 -= this.m_Offset) : (d3 += this.m_Offset);
            }
            double d4 = gfmRectangle2.yMin;
            while (d4 <= gfmRectangle2.yMax) {
                double d5 = d4;
                if (d5 == (double)((int)(d5 / this.m_GridSpacing)) * this.m_GridSpacing) {
                    d5 = d5 + this.m_Offset >= this.m_ModelDomainWidth ? (d5 -= this.m_Offset) : (d5 += this.m_Offset);
                }
                if (d5 - (double)((int)(d5 / this.m_GridSpacing)) * this.m_GridSpacing == d3 - (double)((int)(d3 / this.m_GridSpacing)) * this.m_GridSpacing) {
                    d5 += this.m_Offset;
                }
                if (gfmPolygon2.Contains(d3, d5)) {
                    int n = (int)(d3 / this.m_GridSpacing);
                    int n2 = (int)(d5 / this.m_GridSpacing);
                    int n3 = 2 * (n * this.m_NumRow + n2);
                    if (d5 - (double)n2 * this.m_GridSpacing > d3 - (double)n * this.m_GridSpacing) {
                        ++n3;
                    }
                    double[] dArray = new double[8];
                    double[] dArray2 = new double[]{d3, d5};
                    this.m_Mesh.GetElement(n3).EvaluatePosition(dArray2, dArray);
                    int[] nArray = this.m_Mesh.GetNodeIdsOfElement(n3);
                    double d6 = 0.0;
                    n2 = 0;
                    while (n2 < this.m_Mesh.GetElement(n3).GetNumberOfNodes()) {
                        d6 += this.m_StreamFunction[nArray[n2]] * dArray[n2];
                        ++n2;
                    }
                    gfmParticle gfmParticle2 = new gfmParticle();
                    gfmParticle2.IsActive = true;
                    gfmParticle2.StreamFunctionValue = d6;
                    gfmParticle2.StartingPosition = new gfmPoint(d3, d5);
                    gfmParticle2.StartingElementId = n3;
                    gfmParticle2.Position = new gfmPoint(d3, d5);
                    gfmParticle2.ElementEntryPoint = new gfmPoint();
                    gfmParticle2.ElementExitPoint = new gfmPoint();
                    this.m_ParticleCloud.addElement(gfmParticle2);
                }
                d4 += d;
            }
            d2 += d;
        }
        this.m_ActiveCount = this.m_ParticleCloud.size();
    }

    public void RestartParticles() {
        double[] dArray = new double[8];
        double[] dArray2 = new double[2];
        int n = 0;
        while (n < this.m_ParticleCloud.size()) {
            gfmParticle gfmParticle2 = (gfmParticle)this.m_ParticleCloud.elementAt(n);
            gfmParticle2.IsActive = true;
            gfmParticle2.Position.xx = gfmParticle2.StartingPosition.xx;
            gfmParticle2.Position.yy = gfmParticle2.StartingPosition.yy;
            gfmParticle2.ElementId = gfmParticle2.StartingElementId;
            dArray2[0] = gfmParticle2.Position.xx;
            dArray2[1] = gfmParticle2.Position.yy;
            this.m_Mesh.GetElement(gfmParticle2.ElementId).EvaluatePosition(dArray2, dArray);
            int[] nArray = this.m_Mesh.GetNodeIdsOfElement(gfmParticle2.ElementId);
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.m_Mesh.GetElement(gfmParticle2.ElementId).GetNumberOfNodes()) {
                d += this.m_StreamFunction[nArray[n2]] * dArray[n2];
                ++n2;
            }
            gfmParticle2.StreamFunctionValue = d;
            ++n;
        }
    }

    public void SetDispersivities(double d, double d2) {
        this.m_LongitudinalDispersivity = d;
        this.m_TransverseDispersivity = d2;
    }

    public void SetMakePlot(boolean bl) {
        this.m_MakePlot = bl;
    }

    public void SetTimeStepInSec(double d) {
        this.m_TimeStepInSec = d;
    }

    public void ShowMoments(boolean bl) {
        this.m_ShowMoments = bl;
    }

    public void SetNumberOfStandardDeviations(int n) {
        this.m_Moment12.SetNumberOfStandardDeviations(n);
    }

    public void SetTimeUnit(int n) {
        if (n == 0) {
            this.m_TimeConversionFactor = 1.1574074074074073E-5;
            return;
        }
        if (n == 1) {
            this.m_TimeConversionFactor = 3.1709791983764586E-8;
            return;
        }
        this.m_TimeConversionFactor = 1.0;
    }
}

