/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public abstract class gfmModel {
    protected gfmMesh m_Mesh;
    protected Color[] m_PropertyColor;
    protected int[] m_PropertyIndex;
    protected int m_NumBoundaryValue;
    protected gfmNodeValue[] m_BoundaryValue;
    protected int m_NumBoundaryFlux;
    protected gfmLineValue[] m_BoundaryFlux;
    protected double[] A;
    protected double[] b;
    protected gfmContour m_Contour;

    public void Clear() {
        this.m_Mesh = null;
        this.m_PropertyColor = null;
        this.m_PropertyIndex = null;
        this.m_NumBoundaryValue = 0;
        this.m_BoundaryValue = null;
        this.m_NumBoundaryFlux = 0;
        this.m_BoundaryFlux = null;
    }

    public void DrawBoundary(Graphics graphics, gfmView gfmView2, Color color) {
        this.m_Mesh.DrawBoundary(graphics, gfmView2, color);
    }

    public void DrawContours(Graphics graphics, gfmView gfmView2, Color color) {
        this.m_Contour.Draw(graphics, gfmView2, color);
    }

    public void DrawMesh(Graphics graphics, gfmView gfmView2, Color color) {
        this.m_Mesh.DrawMesh(graphics, gfmView2, color);
    }

    public void DrawPropertyZones(Graphics graphics, gfmView gfmView2) {
        if (this.m_PropertyIndex == null) {
            return;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n = 0;
        while (n < this.m_Mesh.GetNumberOfElements()) {
            graphics.setColor(this.m_PropertyColor[this.m_PropertyIndex[n]]);
            int[] nArray3 = this.m_Mesh.GetNodeIdsOfElement(n);
            int n2 = 0;
            while (n2 < 3) {
                double[] dArray = this.m_Mesh.GetNode(nArray3[n2]);
                Point point = gfmView2.ModelDomainToScene(dArray[0], dArray[1]);
                nArray[n2] = point.x;
                nArray2[n2] = point.y;
                ++n2;
            }
            graphics.fillPolygon(nArray, nArray2, 3);
            ++n;
        }
    }

    public int[] GetPropertyIndex() {
        return this.m_PropertyIndex;
    }

    public void MakeContours(double d) {
        if (this.m_Contour == null) {
            return;
        }
        double d2 = this.b[0];
        double d3 = this.b[0];
        int n = 1;
        while (n < this.m_Mesh.GetNumberOfNodes()) {
            if (d2 < this.b[n]) {
                d2 = this.b[n];
            }
            if (d3 > this.b[n]) {
                d3 = this.b[n];
            }
            ++n;
        }
        if (d2 - d3 < 1.0E-10) {
            return;
        }
        int n2 = (int)((d2 - d3) / d) + 1;
        double[] dArray = new double[n2];
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = d3 + (double)n3 * d;
            ++n3;
        }
        this.m_Contour.MakeContours(dArray);
    }

    public void MakeNContours(int n) {
        if (this.m_Contour == null) {
            return;
        }
        double d = this.b[0];
        double d2 = this.b[0];
        int n2 = 1;
        while (n2 < this.m_Mesh.GetNumberOfNodes()) {
            if (d < this.b[n2]) {
                d = this.b[n2];
            }
            if (d2 > this.b[n2]) {
                d2 = this.b[n2];
            }
            ++n2;
        }
        if (d - d2 < 1.0E-10) {
            return;
        }
        double d3 = (d - d2) / (double)n;
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = d - (double)n3 * d3;
            ++n3;
        }
        this.m_Contour.MakeContours(dArray);
    }

    public void SetBoundaryFlux(int n, gfmLineValue[] gfmLineValueArray) {
        this.m_NumBoundaryFlux = n;
        this.m_BoundaryFlux = gfmLineValueArray;
    }

    public void SetBoundaryValue(int n, gfmNodeValue[] gfmNodeValueArray) {
        this.m_NumBoundaryValue = n;
        this.m_BoundaryValue = gfmNodeValueArray;
    }

    public void SetMesh(gfmMesh gfmMesh2) {
        this.m_Mesh = gfmMesh2;
    }

    public void SetPropertyColor(Color[] colorArray) {
        this.m_PropertyColor = colorArray;
    }

    public void SetPropertyIndex(int[] nArray) {
        this.m_PropertyIndex = nArray;
    }

    public void SetPropertyZone(gfmPolygon gfmPolygon2, int n) {
        int n2 = 0;
        while (n2 < this.m_Mesh.GetNumberOfElements()) {
            boolean bl = true;
            int[] nArray = this.m_Mesh.GetNodeIdsOfElement(n2);
            int n3 = 0;
            while (n3 < 3) {
                double[] dArray = this.m_Mesh.GetNode(nArray[n3]);
                if (!gfmPolygon2.Contains(dArray[0], dArray[1])) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (bl) {
                this.m_PropertyIndex[n2] = n;
            }
            ++n2;
        }
    }

    public abstract void Solve();
}

