/*
 * Decompiled with CFR 0.152.
 */
public class gfmMath {
    private static final double TINY = 1.0E-20;
    private static final double LOG10 = Math.log(10.0);

    public static double DistanceBetweenTwoPoints(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            return -1.0;
        }
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += (dArray[n] - dArray2[n]) * (dArray[n] - dArray2[n]);
            ++n;
        }
        return Math.sqrt(d);
    }

    public static double DistanceBetweenTwoPoints(gfmPoint gfmPoint2, gfmPoint gfmPoint3) {
        return Math.sqrt((gfmPoint2.xx - gfmPoint3.xx) * (gfmPoint2.xx - gfmPoint3.xx) + (gfmPoint2.yy - gfmPoint3.yy) * (gfmPoint2.yy - gfmPoint3.yy));
    }

    public static double NormalDeviate() {
        double d = Math.random();
        double d2 = 1.0;
        if (d > 0.5) {
            d2 = -1.0;
            d = 1.0 - d;
        }
        double d3 = Math.sqrt(Math.log(1.0 / ((1.0 - d) * (1.0 - d))));
        double d4 = d3 - (2.515517 + d3 * (0.802853 + d3 * 0.010328)) / (1.0 + d3 * (1.432788 + d3 * (0.189269 + d3 * 0.001308)));
        return d2 * d4;
    }

    public static double RoundTo(double d, int n) {
        double d2 = Math.floor(Math.log(d) / LOG10);
        double d3 = Math.pow(10.0, -d2 + (double)n);
        return (double)((long)(d * d3)) / d3;
    }

    public static double VectorMagnitude(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n] * dArray[n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public static void SymBandSolver(double[] dArray, double[] dArray2, int n, int n2) {
        int n3;
        double d;
        int n4;
        int n5 = n - 1;
        int n6 = 1;
        while (n6 <= n5) {
            n4 = n - n6 + 1;
            if (n4 > n2) {
                n4 = n2;
            }
            int n7 = 2;
            while (n7 <= n4) {
                d = dArray[n2 * (n6 - 1) + n7 - 1] / dArray[n2 * (n6 - 1)];
                int n8 = n6 + n7 - 1;
                n3 = n7;
                while (n3 <= n4) {
                    int n9 = n3 - n7 + 1;
                    int n10 = n2 * (n8 - 1) + n9 - 1;
                    dArray[n10] = dArray[n10] - d * dArray[n2 * (n6 - 1) + n3 - 1];
                    ++n3;
                }
                int n11 = n8 - 1;
                dArray2[n11] = dArray2[n11] - d * dArray2[n6 - 1];
                ++n7;
            }
            ++n6;
        }
        int n12 = n - 1;
        dArray2[n12] = dArray2[n12] / dArray[n2 * (n - 1)];
        int n13 = 1;
        while (n13 <= n5) {
            n6 = n - n13;
            d = 1.0 / dArray[n2 * (n6 - 1)];
            int n14 = n6 - 1;
            dArray2[n14] = dArray2[n14] * d;
            n4 = n - n6 + 1;
            if (n4 > n2) {
                n4 = n2;
            }
            n3 = 2;
            while (n3 <= n4) {
                int n15 = n6 - 1;
                dArray2[n15] = dArray2[n15] - d * dArray[n2 * (n6 - 1) + n3 - 1] * dArray2[n6 + n3 - 2];
                ++n3;
            }
            ++n13;
        }
    }

    public static void NonsymBandSolver(double[] dArray, double[] dArray2, int n, int n2) {
        double d;
        int n3;
        int n4;
        int n5 = (n2 - 1) / 2;
        int n6 = 1 + n2 / 2;
        double[] dArray3 = new double[n * n6];
        int[] nArray = new int[n];
        int n7 = n5;
        int n8 = 0;
        while (n8 < n5) {
            n4 = n5 - n8;
            while (n4 < n2) {
                n3 = n8 * n2 + n4;
                dArray[n3 - n7] = dArray[n3];
                ++n4;
            }
            n4 = n2 - --n7 - 1;
            while (n4 < n2) {
                dArray[n8 * n2 + n4] = 0.0;
                ++n4;
            }
            ++n8;
        }
        double d2 = 1.0;
        n7 = n5;
        int n9 = 0;
        while (n9 < n) {
            d = dArray[n9 * n2];
            n8 = n9;
            if (n7 < n) {
                ++n7;
            }
            n4 = n9 + 2;
            while (n4 <= n7) {
                if (Math.abs(dArray[(n4 - 1) * n2]) > Math.abs(d)) {
                    d = dArray[(n4 - 1) * n2];
                    n8 = n4 - 1;
                }
                ++n4;
            }
            nArray[n9] = n8;
            if (d == 0.0) {
                dArray[n9 * n2] = 1.0E-20;
            }
            if (n8 != n9) {
                d2 = -d2;
                n4 = 0;
                while (n4 < n2) {
                    d = dArray[n9 * n2 + n4];
                    dArray[n9 * n2 + n4] = dArray[n8 * n2 + n4];
                    dArray[n8 * n2 + n4] = d;
                    ++n4;
                }
            }
            n8 = n9 + 1;
            while (n8 < n7) {
                dArray3[n9 * n6 + n8 - n9 - 1] = d = dArray[n8 * n2] / dArray[n9 * n2];
                n4 = 1;
                while (n4 < n2) {
                    n3 = n8 * n2 + n4;
                    dArray[n3 - 1] = dArray[n3] - d * dArray[n9 * n2 + n4];
                    ++n4;
                }
                dArray[n8 * n2 + n2 - 1] = 0.0;
                ++n8;
            }
            ++n9;
        }
        n7 = n5;
        n9 = 0;
        while (n9 < n) {
            n8 = nArray[n9];
            if (n8 != n9) {
                d = dArray2[n9];
                dArray2[n9] = dArray2[n8];
                dArray2[n8] = d;
            }
            if (n7 < n) {
                ++n7;
            }
            n8 = n9 + 1;
            while (n8 < n7) {
                int n10 = n8;
                dArray2[n10] = dArray2[n10] - dArray3[n9 * n6 + n8 - 1 - n9] * dArray2[n9];
                ++n8;
            }
            ++n9;
        }
        n7 = 1;
        n8 = n - 1;
        while (n8 >= 0) {
            d = dArray2[n8];
            n9 = 1;
            while (n9 < n7) {
                d -= dArray[n8 * n2 + n9] * dArray2[n9 + n8];
                ++n9;
            }
            dArray2[n8] = d / dArray[n8 * n2];
            if (n7 < n2) {
                ++n7;
            }
            --n8;
        }
    }

    public static void Sort(double[] dArray) {
        int n = dArray.length;
        int n2 = 1;
        while (n2 < n) {
            int n3 = n - 1;
            while (n3 >= n2) {
                if (dArray[n3 - 1] > dArray[n3]) {
                    double d = dArray[n3 - 1];
                    dArray[n3 - 1] = dArray[n3];
                    dArray[n3] = d;
                }
                --n3;
            }
            ++n2;
        }
    }
}

