/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.util.Vector;

public class gfmFrame
extends Frame {
    protected boolean m_InAnApplet = true;
    protected boolean m_IsBusy = false;
    protected Button m_ZoomInButton;
    protected Button m_ZoomOutButton;
    protected Button m_OptionsButton;
    protected int m_ZoomInLevel;
    protected gfmView m_View;
    protected Label m_ProgramStatusLabel;
    private Scrollbar m_VertScroll;
    private Scrollbar m_HorzScroll;

    public gfmFrame() {
        this.setTitle("GeoFluid Model");
        ((Component)this).setFont(new Font("Helvetica", 0, 14));
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 1));
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0));
        this.CreateModelButtons(panel2);
        panel.add(panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(0));
        this.m_ZoomInButton = new Button("Zoom In");
        this.m_ZoomOutButton = new Button("Zoom Out");
        this.m_OptionsButton = new Button("Options");
        panel3.add(this.m_ZoomInButton);
        panel3.add(this.m_ZoomOutButton);
        panel3.add(this.m_OptionsButton);
        panel.add(panel3);
        this.add("North", panel);
        gfmPanel gfmPanel2 = new gfmPanel(10, 0, 0, 10);
        gfmPanel2.setLayout(new BorderLayout());
        this.CreateView();
        gfmPanel2.add("Center", this.m_View);
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(1, 0));
        this.CreateStatusBarItems(panel4);
        gfmPanel2.add("South", panel4);
        this.add("Center", gfmPanel2);
        this.m_VertScroll = new Scrollbar(1);
        this.add("East", this.m_VertScroll);
        this.m_HorzScroll = new Scrollbar(0);
        this.add("South", this.m_HorzScroll);
        this.validate();
        this.ResizeHorizontalScroll();
        this.ResizeVerticalScroll();
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Button) {
            this.HandleModelButtons(event, object);
            if (event.target.equals(this.m_ZoomInButton)) {
                this.OnZoomInButton();
            } else if (event.target.equals(this.m_ZoomOutButton)) {
                this.OnZoomOutButton();
            } else if (event.target.equals(this.m_OptionsButton)) {
                this.OnOptionsButton();
            }
        }
        return true;
    }

    protected void CreateStatusBarItems(Panel panel) {
        this.m_ProgramStatusLabel = new Label("Ready", 0);
        panel.add(this.m_ProgramStatusLabel);
    }

    protected void CreateModelButtons(Panel panel) {
    }

    protected void CreateView() {
        this.m_View = new gfmView(this);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                if (event.target == this.m_HorzScroll) {
                    this.OnHorizontalScroll(event);
                    break;
                }
                if (event.target != this.m_VertScroll) break;
                this.OnVerticalScroll(event);
                break;
            }
            case 201: {
                if (!(event.target instanceof gfmFrame)) break;
                this.OnExit();
                break;
            }
        }
        return super.handleEvent(event);
    }

    protected void HandleModelButtons(Event event, Object object) {
    }

    public boolean IsBusy() {
        return this.m_IsBusy;
    }

    public Dimension minimumSize() {
        return new Dimension(640, 480);
    }

    protected void OnExit() {
        if (this.m_InAnApplet) {
            this.dispose();
            return;
        }
        System.exit(0);
    }

    protected void OnFinishedDrawingLine(Vector vector) {
    }

    protected void OnFinishedDrawingPoint(double d, double d2) {
    }

    protected void OnFinishedDrawingPolygon(gfmPolygon gfmPolygon2) {
    }

    private void OnHorizontalScroll(Event event) {
        int n;
        int n2;
        int n3 = (Integer)event.arg;
        if (n3 + (n2 = this.m_View.size().width) > (n = this.m_View.GetSceneWidth())) {
            int n4 = n - n2;
            if (n4 < 0) {
                n4 = 0;
            }
            this.m_View.SetDAOx(n4);
        } else if (n3 < 0) {
            this.m_View.SetDAOx(0);
        } else {
            this.m_View.SetDAOx(n3);
        }
        this.m_View.repaint();
    }

    protected void OnOptionsButton() {
    }

    private void OnVerticalScroll(Event event) {
        int n;
        int n2;
        int n3 = (Integer)event.arg;
        if (n3 + (n2 = this.m_View.size().height) > (n = this.m_View.GetSceneHeight())) {
            int n4 = n - n2;
            if (n4 < 0) {
                n4 = 0;
            }
            this.m_View.SetDAOy(n4);
        } else if (n3 < 0) {
            this.m_View.SetDAOy(0);
        } else {
            this.m_View.SetDAOy(n3);
        }
        this.m_View.repaint();
    }

    private void OnZoomInButton() {
        if (this.m_View.IsDrawing() || this.m_IsBusy) {
            return;
        }
        ++this.m_ZoomInLevel;
        this.m_View.Zoom(1.25);
        this.ResizeHorizontalScroll();
        this.ResizeVerticalScroll();
        if (this.m_ZoomInLevel == 4) {
            this.m_ZoomInButton.disable();
        }
        this.m_View.DrawScene();
    }

    private void OnZoomOutButton() {
        if (this.m_View.IsDrawing() || this.m_IsBusy) {
            return;
        }
        --this.m_ZoomInLevel;
        this.m_View.Zoom(0.8);
        this.ResizeHorizontalScroll();
        this.ResizeVerticalScroll();
        if (this.m_ZoomInLevel == 3) {
            this.m_ZoomInButton.enable();
        }
        this.m_View.DrawBackground();
        this.m_View.DrawScene();
    }

    public void paint(Graphics graphics) {
        this.ResizeHorizontalScroll();
        this.ResizeVerticalScroll();
        this.m_View.repaint();
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    private void ResizeHorizontalScroll() {
        int n = this.m_View.size().width;
        if (n <= 0) {
            return;
        }
        int n2 = this.m_View.GetSceneWidth();
        if (this.m_View.GetDAOx() + n > n2) {
            int n3 = n2 - n;
            if (n3 < 0) {
                n3 = 0;
            }
            this.m_View.SetDAOx(n3);
        }
        this.m_HorzScroll.setValues(this.m_View.GetDAOx(), (int)((double)n * 0.8), 0, n2 - n);
        this.m_HorzScroll.setLineIncrement((int)((double)n * 0.1));
        this.m_HorzScroll.setPageIncrement((int)((double)n * 0.8));
    }

    private void ResizeVerticalScroll() {
        int n = this.m_View.size().height;
        if (n <= 0) {
            return;
        }
        int n2 = this.m_View.GetSceneHeight();
        if (this.m_View.GetDAOy() + n > n2) {
            int n3 = n2 - n;
            if (n3 < 0) {
                n3 = 0;
            }
            this.m_View.SetDAOy(n3);
        }
        this.m_VertScroll.setValues(this.m_View.GetDAOy(), (int)((double)n * 0.8), 0, n2 - n);
        this.m_VertScroll.setLineIncrement((int)((double)n * 0.1));
        this.m_VertScroll.setPageIncrement((int)((double)n * 0.8));
    }

    public void SetProgramStatusLabel(String string) {
        this.m_ProgramStatusLabel.setText(string);
    }

    public static void main(String[] stringArray) {
        gfmFrame gfmFrame2 = new gfmFrame();
        gfmFrame2.m_InAnApplet = false;
        gfmFrame2.pack();
        Dimension dimension = gfmFrame2.size();
        Dimension dimension2 = gfmFrame2.getToolkit().getScreenSize();
        gfmFrame2.move((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        gfmFrame2.show();
    }
}

