/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;

public class gfmFlowDialog
extends gfmDialog {
    protected Checkbox m_FlowPathCheckbox;
    protected Checkbox m_ParticleCheckbox;
    protected Checkbox m_ForwardAndBackwardCheckbox;
    protected Checkbox m_ForwardCheckbox;
    protected Checkbox m_BackwardCheckbox;
    protected Checkbox m_AddToPreviousCheckbox;
    protected TextField m_ParticleSpacingTextField;
    protected int m_TrackDirection;
    protected int m_FlowOption;
    protected double m_ParticleSpacing = 0.0;
    protected String m_ParticleSpacingText = new String();
    protected boolean m_AddToPrevious;

    public gfmFlowDialog(Frame frame) {
        super(frame, "Flow Options");
        this.MakeContents();
    }

    protected void AddComponentsToCenterPanel(gfmPanel gfmPanel2, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Label label = new Label("Options:");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gfmPanel2.add(label);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.m_FlowOption = 0;
        this.m_FlowPathCheckbox = new Checkbox("Flow Path Tracking", checkboxGroup, true);
        this.m_ParticleCheckbox = new Checkbox("Particle Movement", checkboxGroup, false);
        gfmPanel gfmPanel3 = new gfmPanel(5, 10, 10, 10);
        gfmPanel3.setLayout(new GridLayout(0, 1));
        gfmPanel3.add(this.m_FlowPathCheckbox);
        gfmPanel3.add(this.m_ParticleCheckbox);
        gridBagLayout.setConstraints(gfmPanel3, gridBagConstraints);
        gfmPanel2.add(gfmPanel3);
        label = new Label("Direction of Flow Path Tracking");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gfmPanel2.add(label);
        checkboxGroup = new CheckboxGroup();
        this.m_TrackDirection = 0;
        this.m_ForwardAndBackwardCheckbox = new Checkbox("Forward and Backward", checkboxGroup, true);
        this.m_ForwardCheckbox = new Checkbox("Forward Only", checkboxGroup, false);
        this.m_BackwardCheckbox = new Checkbox("Backward Only", checkboxGroup, false);
        gfmPanel3 = new gfmPanel(5, 10, 10, 10);
        gfmPanel3.setLayout(new GridLayout(0, 1));
        gfmPanel3.add(this.m_ForwardAndBackwardCheckbox);
        gfmPanel3.add(this.m_ForwardCheckbox);
        gfmPanel3.add(this.m_BackwardCheckbox);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagLayout.setConstraints(gfmPanel3, gridBagConstraints);
        gfmPanel2.add(gfmPanel3);
        label = new Label("Initial Particle Spacing (meters):");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 5);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gfmPanel2.add(label);
        this.m_ParticleSpacingTextField = new TextField(10);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(this.m_ParticleSpacingTextField, gridBagConstraints);
        gfmPanel2.add(this.m_ParticleSpacingTextField);
        this.m_ParticleSpacingTextField.enable(false);
        ((Component)this.m_ParticleSpacingTextField).setBackground(Color.lightGray);
        this.m_AddToPreviousCheckbox = new Checkbox("Add to previous particles");
        this.m_AddToPrevious = false;
        this.m_AddToPreviousCheckbox.setState(false);
        this.m_AddToPreviousCheckbox.enable(false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(this.m_AddToPreviousCheckbox, gridBagConstraints);
        gfmPanel2.add(this.m_AddToPreviousCheckbox);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.m_OKButton || event.target instanceof TextField) {
            if (this.m_FlowPathCheckbox.getState()) {
                this.m_FlowOption = 0;
                if (this.m_ForwardAndBackwardCheckbox.getState()) {
                    this.m_TrackDirection = 0;
                } else if (this.m_ForwardCheckbox.getState()) {
                    this.m_TrackDirection = 1;
                } else if (this.m_BackwardCheckbox.getState()) {
                    this.m_TrackDirection = -1;
                }
            } else if (this.m_ParticleCheckbox.getState()) {
                this.m_FlowOption = 1;
                try {
                    this.m_ParticleSpacing = Double.valueOf(this.m_ParticleSpacingTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    gfmMessageDialog gfmMessageDialog2 = new gfmMessageDialog(this.m_Parent, "Please enter a positive number for particle spacing.");
                    gfmMessageDialog2.show();
                    return true;
                }
                if (this.m_ParticleSpacing <= 0.0) {
                    gfmMessageDialog gfmMessageDialog3 = new gfmMessageDialog(this.m_Parent, "Please enter a positive number for particle spacing.");
                    gfmMessageDialog3.show();
                    return true;
                }
                this.m_ParticleSpacingText = this.m_ParticleSpacingTextField.getText();
            }
            this.m_AddToPrevious = this.m_AddToPreviousCheckbox.getState();
            ((Component)this).hide();
            ((gfmParticleFlowFrame)this.m_Parent).FlowDialogCallback(this.m_TrackDirection, this.m_ParticleSpacing, this.m_FlowOption, this.m_AddToPrevious);
        } else if (event.target == this.m_CancelButton) {
            this.UndoChanges();
            ((Component)this).hide();
        } else if (event.target == this.m_FlowPathCheckbox) {
            this.m_ForwardCheckbox.enable(true);
            this.m_ForwardAndBackwardCheckbox.enable(true);
            this.m_BackwardCheckbox.enable(true);
            this.m_ParticleSpacingTextField.enable(false);
            ((Component)this.m_ParticleSpacingTextField).setBackground(Color.lightGray);
            this.m_AddToPreviousCheckbox.enable(false);
        } else if (event.target == this.m_ParticleCheckbox) {
            this.m_ForwardCheckbox.enable(false);
            this.m_ForwardAndBackwardCheckbox.enable(false);
            this.m_BackwardCheckbox.enable(false);
            this.m_ParticleSpacingTextField.enable(true);
            ((Component)this.m_ParticleSpacingTextField).setBackground(Color.white);
            this.m_ParticleSpacingTextField.requestFocus();
            this.m_AddToPreviousCheckbox.enable(true);
        }
        return true;
    }

    public void DoModal() {
        if (this.m_FlowOption == 1) {
            this.m_ParticleSpacingTextField.requestFocus();
        }
        super.DoModal();
    }

    protected void UndoChanges() {
        ((TextComponent)this.m_ParticleSpacingTextField).setText(this.m_ParticleSpacingText);
        this.m_AddToPreviousCheckbox.setState(this.m_AddToPrevious);
        if (this.m_FlowOption == 0) {
            this.m_FlowPathCheckbox.setState(true);
            this.m_ParticleCheckbox.setState(false);
            this.m_ForwardCheckbox.enable(true);
            this.m_ForwardAndBackwardCheckbox.enable(true);
            this.m_BackwardCheckbox.enable(true);
            this.m_ParticleSpacingTextField.enable(false);
            ((Component)this.m_ParticleSpacingTextField).setBackground(Color.lightGray);
            this.m_AddToPreviousCheckbox.enable(false);
        } else {
            this.m_FlowPathCheckbox.setState(false);
            this.m_ParticleCheckbox.setState(true);
            this.m_ForwardCheckbox.enable(false);
            this.m_ForwardAndBackwardCheckbox.enable(false);
            this.m_BackwardCheckbox.enable(false);
            this.m_ParticleSpacingTextField.enable(true);
            ((Component)this.m_ParticleSpacingTextField).setBackground(Color.white);
            this.m_AddToPreviousCheckbox.enable(true);
        }
        if (this.m_TrackDirection == 0) {
            this.m_ForwardCheckbox.setState(false);
            this.m_BackwardCheckbox.setState(false);
            this.m_ForwardAndBackwardCheckbox.setState(true);
            return;
        }
        if (this.m_TrackDirection == 1) {
            this.m_ForwardCheckbox.setState(true);
            this.m_BackwardCheckbox.setState(false);
            this.m_ForwardAndBackwardCheckbox.setState(false);
            return;
        }
        if (this.m_TrackDirection == -1) {
            this.m_ForwardCheckbox.setState(false);
            this.m_BackwardCheckbox.setState(true);
            this.m_ForwardAndBackwardCheckbox.setState(false);
        }
    }
}

