/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.peer.PopupMenuPeer;

public class PopupMenu
extends Menu {
    private static final String base = "popup";
    static int nameCounter;
    private static final long serialVersionUID = -4620452533522760060L;

    public PopupMenu() {
        this("");
    }

    public PopupMenu(String string) {
        super(string);
        this.name = base + nameCounter++;
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createPopupMenu(this);
            }
            int n = this.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = this.getItem(n2);
                menuItem.parent = this;
                menuItem.addNotify();
                ++n2;
            }
            return;
        }
    }

    public void show(Component component, int n, int n2) {
        Component component2 = (Component)this.parent;
        if (component2 == null) {
            throw new NullPointerException("parent is null");
        }
        if (component2 != component && component2 instanceof Container && !((Container)component2).isAncestorOf(component)) {
            throw new IllegalArgumentException("origin not in parent's hierarchy");
        }
        if (component2.getPeer() == null || !component2.isShowing()) {
            throw new RuntimeException("parent not showing on screen");
        }
        if (this.peer == null) {
            this.addNotify();
        }
        ((PopupMenuPeer)this.peer).show(new Event(component, 0L, 501, n, n2, 0, 0));
    }
}

