/*
 *	tplook [-short] [label ...] [ < tapedevice]
 *
 *	prints the file and record structure of a tape
 *	-short option prints less verbose output
 *	label argument(s) are printed in output header
 *	default input is /dev/rmt0h unless stdin's a tape device file
 */
/*
 * Keyword: tapes scan
 */

/*
 * revised 2/7/85  stew for new SI tape drive.
 * revised 11/22/85  stew for Convex
 * revised 03/26/86  stew catch interrupts and force printout
 * revised 08/10/90  P. Farrell - set defaults for Pangea; force std out to 
 *	be flushed often so user sees something while tape is running.
   revised 7/20/92 P. Farrell - declare signal catching routine as type
        "void" for Ultrix.
   revised 10/22/92 P. Farrell - change variables that accumulate # of
bytes and # records for file or whole tape to unsigned long in order
to accomodate the new 5GB or greater tape drives -- former signed int
could not accumulate a big enough number.
 * Improvement needed:  default action should be to attempt to open tape 
 * 	drive at various densities, reporting the true density that worked.
 */
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <sys/file.h>
#include <signal.h>
#include <setjmp.h>
#include <stdio.h>
static jmp_buf env;

#define LEN 65535
#define BAD 10
#define SHORT 3

#define DEFMT 0
#define STDIN 1  /* should be last in list */

static char *unitnames[] = { "/dev/rmt0h", "" } ;
static char *unitids[] = { "Exabyte 8500, high density", "stdin" } ;

double x[LEN/8+1];
int rfile;

main (argc,argv)
int argc;
char **argv;
	{
	int i=0, length=0, oldlength=0;
	int bad=0, eof=0, records=0;
	int tfile=0;
	int tape, less=0;
	unsigned long tlength=0, flength=0, trecords=0, frecords=0;
	long tvec = 0;
	extern char *getlogin(), *ctime();
	extern void catchint();

	if(isatape(fileno(stdin))) tape = STDIN;
	else tape = DEFMT;

	while (argc>1 && argv[1][0]=='-')
		{
		argc--; argv++;
		switch (argv[0][1])
			{
		case 's':
			less = 1;
			break;
			}
		}
	argc--; argv++;
/* printf header */
	(void) time (&tvec);
	fprintf (stdout,"Tplook - User: %s  Date: %s",getlogin(),ctime(&tvec));
	if (argc>0) fprintf (stdout,"User Supplied Label:  ");
	for (i=0; i<argc;) fprintf (stdout,"%s ",argv[i++]);
	fprintf (stdout,"\n");
	if (less > 0) fprintf (stdout,"Short listing\n");
	fprintf(stdout,"Reading %s\n\n",unitids[tape]);
	fflush(stdout);

/* open tape drive */
	switch(tape) {
	    case STDIN:
		rfile = fileno(stdin);
		break;
	    default:
	        if ((rfile = open (unitnames[tape],O_RDONLY)) < 0)
		    {
		    fprintf (stderr,"cant open %s\n",unitids[tape]);
		    exit (-1);
		    }
	    }
	signal(SIGINT,catchint);
/* read records */
	while (1)
	{
	length = read (rfile,(char *) x,(int) (LEN));
/* end of file mark */
	if (length == 0)
		{
		if (eof++ == 0)
			{
			if (oldlength < 0)
				{
				if (less == 2) fprintf (stdout,
				"\tfile %-d has %-d bad records at record %-d\n",
				    tfile,records,frecords);
				else fprintf (stdout,"\t%-d bad record(s)\n",
				    records);
				fflush(stdout);
				}
			else
				{
				if (less != 2) {
					fprintf(stdout,
				    "\t%-d record(s) of length %-d\n",
				    records,oldlength);
					fflush(stdout);
					}
				flength += records * oldlength;
				}
			frecords += records;
			if (less != 2 || (tfile % 5) == 0) {
				fprintf (stdout,
			    "file %-d:  #records = %-d  #bytes = %-d\n\n",
			    tfile,frecords,flength);
				fflush (stdout);
				}
			tfile++;
			trecords += frecords;
			tlength += flength;
			flength = records = frecords = 0;
			if (tfile == SHORT && less == 1) less++;
			}
/* end of tape */
		else
			{
			fprintf (stdout,
			    "\ntape: #files = %-d  #records = %-d  ",
			    tfile,trecords);
			fprintf (stdout,
			    "#bytes = %-d  #disk blocks = %-d\n",
			    tlength,tlength/512);
			exit(0);
			}
		}
/* change in record size */
	else 
		{
		eof = 0;
		if (length != oldlength && oldlength != 0)
			{
			if (oldlength < 0)
				{
				if (less == 2) fprintf (stdout,
				"\tfile %-d has %-d bad records at record %-d\n",
				    tfile,records,frecords);
				else fprintf (stdout,"\t%-d bad record(s)\n",
				    records);
				fflush(stdout);
				}
			else 
				{
				if (less != 2) {
					fprintf (stdout,
				    "\t%-d record(s) of length %-d\n",
				    records,oldlength);
					fflush(stdout);
					}
				flength += records * oldlength;
				}
			frecords += records;
			records = 1;
			}
/* same record length */
		else records++;
/* bad records */
		if (length < 0)
			{
			if (++bad == BAD)
				{
				fprintf (stdout,
				    "%d bad records in a row or end of tape\n",
				    BAD);
				trecords += frecords;
				tlength += flength;
				fprintf (stdout,
				    "\ntape: #files = %-d  #records = %-d  ",
				    tfile,trecords);
				fprintf (stdout,
				    "#bytes = %-d  #disk blocks = %-d\n",
				    tlength,tlength/512);
				exit (0);
				}
			}
		else bad = 0;
		}
	oldlength = length;
	}
}

void catchint(sig,code,scp)
int sig,code;
struct sigcontext *scp;
{
 fprintf(stdout,"*** Interrupt ***\n");
 close(rfile); /* one way to force printout and termination */
 rfile = open("/dev/null",0);
}

/*
 * isatape(fd)  -  check if file descriptor corresponds to a tape drive
 *		   returns integer 1 if tape, 0 otherwise.
 */
/*
 * Author - Stewart A. Levin  8/29/83
 * Revised - Stewart A. Levin  11/22/85  for Convex
 * Revised - Stewart A. Levin  2/7/86  system independence
 *
 * If compile stand-alone, be sure to add include statements for
 * 	sys/types.h, sys/ioctl.h, and sys/mtio.h
 *    
 */
#include <errno.h>
extern int errno;

int
isatape(fd)
int fd;
{
 struct mtget buf;

 if(-1 == ioctl(fd,(int) MTIOCGET,(char *) &buf))
	if(errno == EBADF)
		fprintf(stderr,
			"isatape: %d is not a valid file descriptor\n",fd);
	else return(0);
 if(buf.mt_type == ((short) 0)) return(0);
 return(1);
}
