.TH TR2TEX "L" "15 Jan 1987" "Stanford Earth Sciences"
.SH NAME
tr2tex \- convert a document from troff to LaTeX 
.SH SYNOPSIS
.B tr2tex
[
.B -m
] [
.I filenames
]
.SH DESCRIPTION
.I tr2tex
converts troff typesetter formatting commands within a document to
LaTeX formatting commands (a set of high-level macros for
the TeX typesetter program).
It is intended to do the first pass of the conversion. The user
should then finish up the rest of the conversion and customize the
converted document to his/her liking.
It can serve as a tutor for those who want to convert from troff to LaTeX.
.PP
By default,
.I tr2tex
expects a document to be written with plain troff commands; the
.B -ms
macros; or
.B eqn
preprocessor symbols.
It also understands and converts very simple tables set up with
.B tbl
preprocessor symbols.
Any text, such as complicated tables, which 
.I tr2tex
cannot convert is copied to the output with the LaTeX comment character
(%) added at the start of each line.
This prevents major errors when attempting a first pass processing run of
the converted document.
.PP
To convert UNIX manual entries that use the troff 
.B -man 
macros, specify the
.B -m
option on the command line.  
.PP
The converted LaTeX document will specify \\documentstyle[
.I option
]{article},
where 
.I option
is either
.B troffms
or 
.B troffman,
depending upon whether -ms macros (default) or -man macros (-m option)
are being translated.
(These options read .sty files of the same name from the system TeX macro 
directory.
These files define special LaTeX macros to handle some troff -ms and
-man macros that have no direct LaTeX equivalents.)
If you want the Stanford Exploration Project (SEP) page layout, 
section headings, and other style parameters, simply substitute "sep" 
for "troffms" in the converted LaTeX document.
The sep.sty file is a superset of troffms.sty.
.PP
By default, 
.I tr2tex
reads from standard input and writes to standard output and can participate
in pipes.
A filename may be specified on the command line to read from that file
instead of standard input.
If multiple input files are specified, they will be concatenated and 
converted into a single output LaTeX file.
The input troff file(s) is preserved.
.PP
If called without any command line arguments, and not as part of a pipe,
.I tr2tex
self-documents with a brief syntax summary and quits.
.SH BUGS AND QUIRKS
Many of these bugs are harmless. Most of them cause local errors
that can be fixed in the converted document.
.PP
\- Some troff macros and macro arguments are not recognized; they are simply
copied to LaTeX comment lines in the output.
.PP
\- Headers and footers in the converted LaTeX document are handled by 
special macros defined in troffms.sty or troffman.sty that are 
incompatible with the normal LaTeX \\pagestyle command.
.PP
\- Title and author lines are handled differently in troff with -ms macros
than in LaTeX, necessitating some manual conversion.  
Basically, the -ms macros permit multiple .AU and .AI macro calls to define 
authors and institutions, whereas LaTeX normally wants only a single 
\\author macro call whose argument is the entire list of authors and 
institutions (with line break control characters inserted where desired).  
Furthermore, normal LaTeX demands an explicit \\maketitle call to print out 
the defined title and author lines, whereas the SEP version of LaTeX does not.
The solution adopted by the translator is this:  (1) the LaTeX \\author
macro has been redefined in troffms.sty, and an \\authoraff macro added,
so that multiple calls will just add additional lines to the stored 
author list; (2) each .AU and .AI call in the input troff document is 
translated to a separate \\author or \\authoraff macro in the output LaTeX
document; and (3) the user must add the \\maketitle call himself to the LaTeX
document (users of sep.sty do 
.B not 
add this call).  
Also be sure that the \\title, \\author, \\authoraff, and \\maketitle calls 
in the LaTeX document come before any text or \\par calls.
.PP
\- If you use an in-line mathematics delimiter with eqn symbols, you must
define that delimiter with 
.B delim
within the troff document that you are converting.
If the delimiter is defined in another setup file, that file must be 
included as one of the input files to 
.I tr2tex;
otherwise, the in-line math will be treated as ordinary text.
.PP
\- Troff commands that are not separated from their argument by a space are
not properly parsed (e.g .sp3i).
.PP
\- When some troff operators (notably over, sub and sup) are renamed 
(via define), then when they are encountered in the text,
.I tr2tex
will treat them as
ordinary macros and will not apply their rules.
.PP
\- rpile and lpile are treated the same as cpile.
.PP
\- rcol and lcol are treated the same as ccol.
.PP
\- Math-mode size, gsize, fat, and gfont are ignored.
.PP
\- lineup and mark are ignored because the troff and LaTeX 
rules are so different.
.PP
\- Line spacing is not changed within a paragraph in LaTeX
(which is a bad practice anyway).
LaTeX uses the last line spacing in effect in that paragraph.
.PP
\- `a sub i sub j' is converted to `a_i_j' which LaTeX complains is vague
(is `j' a subscript of `i' or of `a').
However, `a sub {i sub j}' is parsed correctly and converted to 'a_{{i}_j}'.
.PP
\- When local motions in the troff document are converted to \\raise or
\\lower commands in the LaTeX output, the raised or lowered text needs 
to be typset with a LaTeX \\hbox command.  
The user must add this \\hbox command manually.
.PP
\- Switching typesetting modes in LaTeX usually requires explicit commands
to begin and end the new mode, whereas in troff you can often begin a 
new mode that just stays in effect until the end of the document if not
explicitly ended.  
If the ending command is not specified in the input troff document,
the converted LaTeX document may produce errors when processed.
Example: troff .nf not closed by .fi.
.SH FILES
/usr/lib/tex/macros/troffms.sty \- LaTeX macros for converting 
troff -ms macros.
.br
/usr/lib/tex/macros/troffman.sty \- LaTeX macros for converting
troff -man macros.
.br
/usr/lib/tex/macros/sep.sty \- SEP macros for page layout, headings, etc.; superset of troffms.sty.
.SH "SEE ALSO"
tex(L) \- TeX text formatter program (produces .dvi file).
.br
texpr(L) \- script to format and print in one step.
.br
latex(L) \- invoke TeX with pre-loaded LaTeX macros.
.br
bibtex(L) \- Produce LaTeX bibliographies.
.br
dvi-imagen(L), dviimp(L), dvi2ps(L) \- filters for output printing devices.
.br
dviselect(L) \- select pages from DVI file.
.br
detex(L), texeqn(L), texexpand(L), texmatch(L)
\- programs to process or check a TeX source file.
.br
Donald E. Knuth,
.I The TeXbook
.br
Leslie Lamport,
.I LaTeX \- A Document Preparation System
.SH AUTHOR
Kamal Al-Yahya, Stanford University
.SH TODO
Access registers via
.B .nr
command.
