.TH TEXMATCH "L" "8 Aug 1987" "Stanford Earth Sciences"
.SH NAME
texmatch \- checks matching in TeX and LaTeX documents.
.SH SYNOPSIS
.B texmatch
.I options parameters inputfiles
.SH DESCRIPTION
.I texmatch
gives error messages if it detects unmatched pairs of delimiters
(braces, brackets, parentheses, dollar signs, 
and \\begin ... \\end sequences) in TeX and LaTeX documents.
Error messages are sent to the standard error.
(No other output is created.)
Escaped or commented delimiters are not checked.
Text, displayed equations, and environments are checked separately.
Commented text is not checked.
.PP
.B Options
.TP
.B \-i
.I texmatch
normally recognizes and opens files called by TeX's and LaTeX's \\input
and \\include commands. The
.B -i
flag makes
.I texmatch
ignore these included files.
.PP
.B Parameters:
.TP
.B in=
An input file to be processed may be specified by a parameter of the 
form 
.BI in= filename.
.I texmatch
reads and concatenates input files from several sources in the following
order: 
re-directed or piped standard input;
a file specified by the 
.B in=
parameter; and finally,
filenames given on the command line after any flags or parameters. 
.SH BUGS and DIAGNOSTICS
LaTeX environments that are started and ended by user-defined
control sequences are regarded as text and they are not checked
separately.
.PP
LaTeX \\begin{...} and \\end{...} statements are not recognized if they
contain embedded spaces.
.SH "SEE ALSO"
tex(L) \- TeX text formatter program (produces .dvi file).
.br
texpr(L) \- script to format and print in one step.
.br
latex(L) \- invoke TeX with pre-loaded LaTeX macros.
.br
bibtex(L) \- Produce LaTeX bibliographies.
.br
dvi-imagen(L), dviimp(L), dvi2ps(L) \- filters for output printing devices.
.br
dviselect(L) \- select pages from DVI file.
.br
detex(L), texeqn(L), texexpand(L)
\- programs to process or check a TeX source file.
.br
tr2tex(L) \- translate troff documents to LaTeX.
.br
Donald E. Knuth,
.I The TeXbook
.br
Leslie Lamport,
.I LaTeX \- A Document Preparation System
.SH AUTHOR
Kamal Al-Yahya, Stanford University
