.TH TEXEXPAND "L" "3 Aug 1987" "Stanford Earth Sciences"
.SH NAME
texexpand \- expands TeX's \\input and LaTeX's \\input{} and \\include{}.
.SH SYNOPSIS
.B texexpand
.I options parameters inputfiles
.SH DESCRIPTION
A TeX or LaTeX document can have included files.
.I texexpand
creates a new copy of the document after inserting these files. 
The name of the included file has to be correct relative to the current working
directory (or a complete path name must be specified). If
.I filename
cannot be opened, it will try to open
.I filename.tex.
The character '%' (but not \\%) is recognized as a comment indicator;
any following \input or \include statement on that line is ignored.
.PP
.B Options
.TP
.B \-w
.I texexpand
normally calls
.I texmatch
to check for mis-matched braces and prints a warning to standard
error whenever it finds a suspected unmatched brace.
The
.B -w
flag suppresses this checking.
.PP
.B Parameters:
.TP
.B in=
An input file to be processed may be specified by a parameter of the 
form 
.BI in= filename.
.I texexpand
reads and concatenates input files from several sources in the following
order: 
re-directed or piped standard input;
a file specified by the 
.B in=
parameter; and finally,
filenames given on the command line after any flags or parameters. 
.TP
.B out=
.I texexpand
normally writes the expanded file to standard output.  
Output may be directed to a file by a parameter specification of the form
.BI out= filename.
.SH DIAGNOSTICS
Nesting of \\input and \\include is allowed but the number of opened files
must not exceed the system's limit on the number of simultaneously opened
files (normally < 20).
.PP
LaTeX \\begin{...} and \\end{...} statements are not recognized if they
contain embedded spaces.
.SH "SEE ALSO"
tex(L) \- TeX text formatter program (produces .dvi file).
.br
texpr(L) \- script to format and print in one step.
.br
latex(L) \- invoke TeX with pre-loaded LaTeX macros.
.br
bibtex(L) \- Produce LaTeX bibliographies.
.br
dvi-imagen(L), dviimp(L), dvi2ps(L) \- filters for output printing devices.
.br
dviselect(L) \- select pages from DVI file.
.br
detex(L), texeqn(L), texmatch(L)
\- programs to process or check a TeX source file.
.br
tr2tex(L) \- translate troff documents to LaTeX.
.br
Donald E. Knuth,
.I The TeXbook
.br
Leslie Lamport,
.I LaTeX \- A Document Preparation System
.SH AUTHOR
Kamal Al-Yahya, Stanford University
