.TH TEXEQN "L" "3 Aug 1987" "Stanford Earth Sciences"
.SH NAME
texeqn \- extracts equations only from TeX or LaTeX source file
.SH SYNOPSIS
.B texeqn
.I options parameters inputfiles
.SH DESCRIPTION
It is sometimes desirable to check only the equations of a TeX or
LaTeX document.
.I texeqn
extracts those patterns that constitute displayed equations from the 
input:  anything surrounded by
.I two
dollar signs; \\begin{equation} and \\end{equation};
\\begin{eqnarray} and \\end{eqnarray}; or
\\begin{displaymath} and \\end{displaymath}.
Note that this also includes any text that is displayed
in this fashion even if it is not an equation.
Macros defined by \\def or \\newcommand are also extracted, as they may
be used in the equations.
Text commented by '%' is ignored.
.PP
.B Options
.TP
.B \-i
.I texeqn
normally recognizes and opens files called by TeX's and LaTeX's \\input
and \\include commands. The
.B -i
flag makes
.I texeqn
ignore these included files.
.TP
.B \-w
.I texeqn
normally calls
.I texmatch
to check for mis-matched braces and prints a warning to standard
error whenever it finds a suspected unmatched brace.
The
.B -w
flag suppresses this checking.
.PP
.B Parameters:
.TP
.B in=
An input file to be processed may be specified by a parameter of the 
form 
.BI in= filename.
.I texeqn
reads and concatenates input files from several sources in the following
order: 
re-directed or piped standard input;
a file specified by the 
.B in=
parameter; and finally,
filenames given on the command line after any flags or parameters. 
.TP
.B out=
.I texeqn
normally writes the selected equations to standard output.  
Output may be directed to a file by a parameter specification of the form
.BI out= filename.
.PP
Using 
.I texeqn 
alone does not typest the equations. If you want them typeset, process the
file of extracted equations with the
.I texpr
(L) program.
.SH BUGS and DIAGNOSTICS
Displayed equations that are started and ended by user-defined
control sequences will not be selected.
.PP
LaTeX \\begin{...} and \\end{...} statements are not recognized if they
contain embedded spaces.
.SH "SEE ALSO"
tex(L) \- TeX text formatter program (produces .dvi file).
.br
texpr(L) \- script to format and print in one step.
.br
latex(L) \- invoke TeX with pre-loaded LaTeX macros.
.br
bibtex(L) \- Produce LaTeX bibliographies.
.br
dvi-imagen(L), dviimp(L), dvi2ps(L) \- filters for output printing devices.
.br
dviselect(L) \- select pages from DVI file.
.br
detex(L), texexpand(L), texmatch(L)
\- programs to process or check a TeX source file.
.br
tr2tex(L) \- translate troff documents to LaTeX.
.br
Donald E. Knuth,
.I The TeXbook
.br
Leslie Lamport,
.I LaTeX \- A Document Preparation System
.SH AUTHOR
Kamal Al-Yahya, Stanford University
