.TH DETEX "L" "3 Aug 1987" "Stanford Earth Sciences"
.SH NAME
detex \- filter to strip TeX and LaTeX command constructs from a file.
.SH SYNOPSIS
.B detex 
.I options parameters inputfiles
.SH DESCRIPTION
TeX and LaTeX have control characters that
.B spell
and other
.I troff
-dependent
processors (like diction) do not recognize.
.I detex
works as a preprocessor by
filtering those control characters. 
.I detex
does not break the document into individual words. It merely
.I erases
the control sequences.
The character '%' (but not \\%) is recognized as a comment indicator and 
the commented text is not passed to the output.
In-line or displayed equations are not passed to the output.
.PP
.B Options
.TP
.B \-i
.I detex
normally recognizes and opens files called by TeX's and LaTeX's \\input
and \\include commands. The
.B -i
flag makes
.I detex
ignore these included files.
.TP
.B \-w
.I detex
normally calls
.I texmatch
to check for mis-matched braces and prints a warning to standard
error whenever it finds a suspected unmatched brace.
The
.B -w
flag suppresses this checking.
.PP
.B Parameters:
.TP
.B in=
An input file to be processed may be specified by a parameter of the 
form 
.BI in= filename.
.I detex
reads and concatenates input files from several sources in the following
order: 
re-directed or piped standard input;
a file specified by the 
.B in=
parameter; and finally,
filenames given on the command line after any flags or parameters. 
.TP
.B out=
.I detex
normally writes the filtered output to standard output.  
Output may be directed to a file by a parameter specification of the form
.BI out= filename.
.SH BUGS and DIAGNOSTICS
If no arguments of any kind are included on the command line, and
.I detex
is not part of a pipe, it does not read from the default standard input 
but simply prints a page of documentation.
.PP
An input or included file name has to be correct relative to the current 
working directory (or a complete path name must be specified).
If 
.I detex 
cannot open the file nor file_name.tex, it will give a non-fatal
error message and proceed.
.PP
Nesting of \\input and \\include is allowed but the number of opened files
must not exceed the system's limit on the number of simultaneously opened
files (normally < 20).
.PP
LaTeX \\begin{...} and \\end{...} statements are not recognized if they
contain embedded spaces.
.SH "SEE ALSO"
tex(L) \- TeX text formatter program (produces .dvi file).
.br
texpr(L) \- script to format and print in one step.
.br
latex(L) \- invoke TeX with pre-loaded LaTeX macros.
.br
bibtex(L) \- Produce LaTeX bibliographies.
.br
dvi-imagen(L), dviimp(L), dvi2ps(L) \- filters for output printing devices.
.br
dviselect(L) \- select pages from DVI file.
.br
texeqn(L), texexpand(L), texmatch(L)
\- programs to process or check a TeX source file.
.br
tr2tex(L) \- translate troff documents to LaTeX.
.br
Donald E. Knuth,
.I The TeXbook
.br
Leslie Lamport,
.I LaTeX \- A Document Preparation System
.SH AUTHOR
Kamal Al-Yahya, Stanford University
