/*     
 *   This routine is designed to fix up the problem of different fortran
 *   compilers having different names for the external variables that are
 *   equivalent to the C-language  argc and argv.
 *
 *   Seplib assumes that that these values are in the external variables
 *   xargc and xargv.
 *
 *   This routine must fix this up for the current machine.
 *   Test for machine type and apply the appropriate fix.
 *
 *   If the pre-processor macro XARGFIX is defined then
 *   this routine will be called as the first thing done in all seplib
 *   routines that expect to use xargc and xargv.
 *   See for example getch_.c
 *
 *   XARGFIX is defined, if needed, in the machdep file in this directory.
 *
 *   Author: Dave Nichols, 6/22/89
 *   Revised 2 July 1990 - Phil Farrell - use automatic compiler flag 
 *      MIPSEL instead of the combination of MIPS & ULTRIX for Digital
 *      RISC ULTRIX machines (DECstation, DECsystem).  Also, took out 
 *      redundant XARGFIX ifdef bracketting the entire routine.
 *
 *
 */

#ifdef MIPSEL
	/* its a DECstation 3100 or similar */
	int f77argc;
	char** f77argv;
#endif

int xargc ;
char** xargv ;

void xargfix()
{

#ifdef MIPSEL
	/* its a DECstation 3100 or similar */

	extern int f77argc;
	extern char** f77argv;

	if( xargc <= 0 ) {  /* needs fixing */

		/* just copy the values f77argc and f77argv */
		xargc = f77argc;
		xargv = f77argv;

	}
#endif

	return;

}
