/*
 *
 *  source file:   ./filters/loclib/getch_.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Modified 6/23/89  Dave Nichols 
 *	   added xargfix call to fix up external variables
 * Modified 8/4/89  Dave Nichols 
 *	   made the routine varargs, copied form Stew's stuff.
 * Revised 2 July 90 Phil Farrell - automatically define XARGFIX
 *         for Digital RISC ULTRIX machines (DECstation, DECsystem).
 */

#include <varargs.h>
#include "fastpar.h"

/* 
   On Digital RISC ULTRIX machines, compiler automatically defines MIPSEL
   flag, so use this to define XARGFIX for these machines if
   not already defined.
*/
#ifndef XARGFIX
#ifdef MIPSEL
#define XARGFIX
#endif
#endif

#define GETCH_QUEUE_SIZE  127

hash_item *getch_queue[GETCH_QUEUE_SIZE];
int getch_queue_size = GETCH_QUEUE_SIZE;

/*VARARGS0*/
int
getch_( va_alist /*tag,type,ptr*/)
va_dcl
{
 register int iargc;
 char *tag, *type;
 va_list apdum;
 static int first_invoke = 1;
 extern int xargc; extern char **xargv;
 MIXED var;

#ifdef XARGFIX
	extern void xargfix();
	xargfix();
#endif


 if(first_invoke) {
    for(iargc=1; iargc<xargc; iargc++) 
	getpar_string_store(getch_queue,getch_queue_size,xargv[iargc]);
    first_invoke = 0;
    }

 va_start( apdum );
 tag = va_arg(apdum,char*);
 type = va_arg(apdum,char*);
 switch(type[0]) {
 case 'g': var.g = va_arg(apdum,double *); break;
 case 's': var.s = va_arg(apdum,char *); break;
 case 'f': case 'r': var.f = va_arg(apdum,float *); break;
 default: var.i = va_arg(apdum,int *); break;
 }
 va_end(apdum);
	
 return (getpar_decode(getch_queue,getch_queue_size,tag,type,var));
}

getch_add_string_(string)
char *string;
{
	getpar_string_store(getch_queue,getch_queue_size,string);
}
