%C
NONWHITE	[^ \t\n]
ALPHA	[A-Za-z]
ALPHANUM	[A-Za-z0-9_-]
TAG	{ALPHA}{ALPHANUM}*=
SQ	\'([^'\n]*\'\')*[^'\n]*['\n]
DQ	\"([^"\n]*\"\")*[^"\n]*["\n]
%{
/* lexical scanning for fast getpar */
/* Revised 3-8-86 stew  Added time stamp to enable older method of handling
 *			multiple tags.  Moved par= intiialization to
 *			separate routine to avoid code duplication.
 * Revised 5-15-89 farrell  Size in suballoc forced to WORDSIZE boundary.
 */
#include <ctype.h>
#include "fastpar.h"
#undef input
#define input() ((int) *(input_stack[input_depth]++))
#undef unput
/* The redundant  =(c) insures side effects of expressions occur */
#define unput(c) (*(--(input_stack[input_depth]))=(c))
#define yywrap() getpar_pop_input()
#define yylex() getpar_lexscan()
#define yylook() getpar_yylook()

#define MAX_INPUT_DEPTH 10
static int input_depth = -1;
static char *input_stack[MAX_INPUT_DEPTH];
static char *dealloc_stack[MAX_INPUT_DEPTH];

static struct {
	char *tag;  int tlen;
	char *val;  int vlen;
       } yy;


#define WORDSIZE 8
static int  SMALLBLOCK = 4096;
static char
*suballoc (size)
int size;
{
	static char *myblock = (char *) NULL; static int bytesleft = 0;
	char *ptr; extern char *alloc();
	int allocsize;

	if (size % WORDSIZE == 0) {
		allocsize = size;
	} else {
		allocsize = ( (size / WORDSIZE) + 1) * WORDSIZE;
		}
	if(allocsize > SMALLBLOCK) return(alloc(allocsize));
	else
	  { 
	    if(bytesleft < allocsize)
	       {
	        myblock = alloc (SMALLBLOCK);
		bytesleft = SMALLBLOCK - allocsize;
	       }
	   else
	       {
		bytesleft -= allocsize;
	       }
	   ptr = myblock;
	   myblock += allocsize;
	   return(ptr);
	  }
}

static int  prime[10] = {31,29,23,19,17,13,11,7,5,3};
int getpar_hash(array,len)
register char *array;
register int len;
{
  register int hash;
  register int i;
  if(len >10) len=10;
  hash=0;
  for(i=0; i<len; i++)
    hash += array[i]*prime[i];
  return(hash);
}

/* workhorse to decode par files; shell already parses command line */
getpar_scan(queue,qlen)
register hash_item **queue;
register int qlen;
{
 extern int yylex();

 while(yylex()) {
	getpar_hash_store(queue,qlen,yy.tag,yy.val,yy.tlen,yy.vlen);
	if(yy.tlen == 3 && 0 == bcmp(yy.tag,"par",3))
		getpar_stack_par(yy.val);
	}
}

/* read parfile into core and put buffer on scan input stack */
getpar_stack_par(val)
char *val;
{
 register char *buffer;
 register int fd, len;
 extern int file(), fsize();
 extern char *alloc();

    fd = file(val,0);
    len = fsize(fd);
    buffer=alloc(len+3);
    buffer[0]='\n';
    read(fd,buffer+1,len);
    buffer[len+1]='\n';
    buffer[len+2]='\0';
    getpar_push_input(buffer,1);
    close(fd);
}

 /* return 1 if match; 0 otherwise */
#define getpar_hash_compare(next1,tag1,tlen1)  \
 ((next1)->tlen == (tlen1) && 0 == bcmp((next1)->tag,tag1,tlen1))

getpar_hash_store(q,qlen,tag,val,tlen,vlen)
hash_item **q;
register char *tag, *val;
register int tlen;
int qlen, vlen;
{
 register hash_item *hold, *next;
 static int storetime = 0;

 hold=(hash_item *) (q+getpar_hash(tag,tlen)%qlen);
 next=hold->next;

 while(next != ((hash_item *) NULL)) {
	if(getpar_hash_compare(next,tag,tlen) ) {
		next->val = val; next->vlen = vlen;
		next->timestamp = storetime++; return;
		}
	hold = next; next = next->next;
	}

 hold->next = next = (hash_item *) suballoc(sizeof(hash_item));
 next->next = (hash_item *) NULL;
 next->tlen = tlen;
 next->tag = tag;
 next->vlen = vlen;
 next->val = val;
 next->timestamp = storetime++;
}

hash_item *getpar_hash_lookup(q,qlen,tag,tlen)
register hash_item **q;
register char *tag;
register int tlen;
register int qlen;
{
 register hash_item *next;

 next = *(q + getpar_hash(tag,tlen)%qlen);

 while(next != ((hash_item *) NULL) ) {
	if(getpar_hash_compare(next,tag,tlen)) break;
	next = next->next;
	}
 return(next);
}

%}
%S FOUNDTAG
%%
<FOUNDTAG>{SQ}		{
			 yy.vlen = yyleng-2; yy.val=suballoc(yy.vlen+1);
			 yy.vlen = massage(yytext+1,yy.val,yy.vlen,yytext[0]);
			 yy.val[yy.vlen]='\0'; BEGIN 0; return(FOUNDTAG);
			 }
<FOUNDTAG>{DQ}		{
			 yy.vlen = yyleng-2; yy.val=suballoc(yy.vlen+1);
			 yy.vlen = massage(yytext+1,yy.val,yy.vlen,yytext[0]);
			 yy.val[yy.vlen]='\0'; BEGIN 0; return(FOUNDTAG);
			 }
<FOUNDTAG>[^'"]{NONWHITE}*	{
				 yy.vlen=yyleng; yy.val=suballoc(yy.vlen+1);
		 		 bcopy(yytext,yy.val,yy.vlen+1); BEGIN 0;
				 return(FOUNDTAG);
				 }
^{TAG}/{NONWHITE}	{
			 yy.tlen=yyleng-1; yy.tag=suballoc(yy.tlen+1);
			 bcopy(yytext,yy.tag,yy.tlen);
			 yy.tag[yy.tlen]='\0'; BEGIN FOUNDTAG;
			 }
([ \t]{TAG})/{NONWHITE}	{
			 yy.tlen=yyleng-2; yy.tag=suballoc(yy.tlen+1);
			 bcopy(yytext+1,yy.tag,yy.tlen);
			 yy.tag[yy.tlen]='\0'; BEGIN FOUNDTAG;
			 }
^\#.*	/* skip comment lines */;
.	|
\n	;
%%
	getpar_push_input(buffer,dealloc)
	register char *buffer;
	register int dealloc;
	{
	  if(input_depth++ == MAX_INPUT_DEPTH)
		err("too many nested par files\n");
	  input_stack[input_depth] = buffer;
	  if(dealloc) dealloc_stack[input_depth] = buffer;
	  else dealloc_stack[input_depth] = (char *) NULL;
	}

	int
	yywrap()
	{
	  if(((char *) NULL) != dealloc_stack[input_depth]) {
		free(dealloc_stack[input_depth]);
		dealloc_stack[input_depth] = (char *) NULL;
		}
	  input_stack[input_depth--] = (char *) NULL;
	  if(input_depth < 0) return(1);
	  return(0);
	}

	static int
	massage(string,out,len,quote)
	register char *string, *out;
	register int len, quote;
	{
 	register int i,j;
	
	for(i=0,j=0; i<len-1; j++) {
		out[j]=string[i++];
		if(out[j]==quote) /* compress doubled quotes */
			if(string[i]==quote) i++;
		}
	if(i<len) out[j++] = string[i];
	return(j);
	}
