/*
 * GKS FUNCTION NAME:  Set Window
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetwindow(transform,window)
 *        int transform;
 *        Glimit *window;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gswn(tnr,xmin,xmax,ymin,ymax)
 *        integer tnr
 *        real xmin,xmax,ymin,yax
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Window";

#ifdef FORTRAN

#define XMIN	(*xmin)
#define XMAX	(*xmax)
#define YMIN	(*ymin)
#define YMAX	(*ymax)
#define TNR		*tnr

gswn_(tnr,xmin,xmax,ymin,ymax)
register int TNR;
float *xmin,*xmax,*ymin,*ymax;

#else

#define XMIN	(window->xmin)
#define XMAX	(window->xmax)
#define YMIN	(window->ymin)
#define YMAX	(window->ymax)
#define TNR		tnr

gswn(tnr,window)
register int TNR;
Glimit *window;

#endif
{
	register struct Gnormtran *nptr;
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		error=8;
		goto gkserror;
	}
	if( (TNR < 1) || ( TNR > (NNORMTRAN-1)))
	{
		error=50;
		goto gkserror;
	}
	if( (XMIN >= XMAX) || (YMIN >= YMAX))
	{
		error=51;
		goto gkserror;
	}
#endif

	nptr = _gks.normtran + TNR;
#ifdef FORTRAN
	nptr->window.xmin = XMIN;
	nptr->window.xmax = XMAX;
	nptr->window.ymin = YMIN;
	nptr->window.ymax = YMAX;
#else
	nptr->window = *window;
#endif
	gudntran(nptr);
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
