/*
 * GKS FUNCTION NAME:  Set Workstation Window
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetwswindow(ws,window)
 *        int ws;
 *        Glimit *window;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gswkwn(wkid,xmin,xmax,ymin,ymax)
 *        integer wkid
 *        real xmin,xmax,ymin,yax
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"
#include "metafile.h"

static char *name="Set Workstation Window";

#ifdef FORTRAN

#define XMIN	(*xmin)
#define XMAX	(*xmax)
#define YMIN	(*ymin)
#define YMAX	(*ymax)
#define WS		*wkid

gswkwn_(wkid,xmin,xmax,ymin,ymax)
register int *wkid;
float *xmin,*xmax,*ymin,*ymax;

#else

#define XMIN	(window->xmin)
#define XMAX	(window->xmax)
#define YMIN	(window->ymin)
#define YMAX	(window->ymax)
#define WS		ws

gswkwn(ws,window)
register int ws;
Glimit *window;

#endif
{
	register Gwsstatelist *wsptr;
	register Gdevsw *dev;
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_7)
	{
		error=7;
		goto gkserror;
	}
	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error=20;
		goto gkserror;
	}
#endif

	wsptr = _gks.workstation[WS];
	if( !wsptr) 
	{
		error=25;
		goto gkserror;
	}

#ifndef FAST
	if((XMIN >= XMAX) || (YMIN >= YMAX))
	{
		error=51;
		goto gkserror;
	}
	if((XMIN < 0.) || (YMIN < 0.) || (XMAX > 1.) || (YMAX > 1.))
	{
		error=53;
		goto gkserror;
	}
#endif

	dev = _gdevsw + gmajordev(wsptr->type);
#ifdef FORTRAN
	wsptr->reqwindow.xmin = XMIN;
	wsptr->reqwindow.xmax = XMAX;
	wsptr->reqwindow.ymin = YMIN;
	wsptr->reqwindow.ymax = YMAX;
#else
	wsptr->reqwindow = *window;
#endif
	wsptr->tranudpending = GPENDING;
	(*(dev->wsattributes))(WINDOW,wsptr);
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
