/*
 * GKS FUNCTION NAME:  Set Workstation Viewport
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetwsviewport(ws,viewport)
 *        int ws;
 *        Glimit *viewport;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gswkvp(wkid,xmin,xmax,ymin,ymax)
 *        integer wkid
 *        real xmin,xmax,ymin,yax
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "wstable.h"
#include "extern.h"
#include "metafile.h"
extern Gwstable *_wstable[];

static char *name="Set Workstation Viewport";

#ifdef FORTRAN

#define XMIN	(*xmin)
#define XMAX	(*xmax)
#define YMIN	(*ymin)
#define YMAX	(*ymax)
#define WS		*wkid

gswkvp_(wkid,xmin,xmax,ymin,ymax)
register int *wkid;
float *xmin,*xmax,*ymin,*ymax;

#else

#define XMIN	(viewport->xmin)
#define XMAX	(viewport->xmax)
#define YMIN	(viewport->ymin)
#define YMAX	(viewport->ymax)
#define WS		ws

gswkvp(ws,viewport)
register int ws;
Glimit *viewport;

#endif
{
	register Gwsstatelist *wsptr;
	register Gdevsw *dev;
	register Gwstable *wsd;
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_7)
	{
		error=7;
		goto gkserror;
	}
	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error=20;
		goto gkserror;
	}
#endif

	wsptr = _gks.workstation[WS];
	if( !wsptr) 
	{
		error=25;
		goto gkserror;
	}

#ifndef FAST
	if((XMIN >= XMAX) || (YMIN >= YMAX))
	{
		error=51;
		goto gkserror;
	}
#endif

	dev = _gdevsw + gmajordev(wsptr->type);
	wsd = _wstable[wsptr->type];

#ifndef FAST
	if( (XMIN < 0.)||(YMIN < 0 ) ||
		(XMAX > wsd->dspsize.device.x) ||
		(YMAX > wsd->dspsize.device.y))
	{
		error=54;
		goto gkserror;
	}
#endif

#ifdef FORTRAN
	wsptr->reqviewport.xmin = XMIN;
	wsptr->reqviewport.xmax = XMAX;
	wsptr->reqviewport.ymin = YMIN;
	wsptr->reqviewport.ymax = YMAX;
#else
	wsptr->reqviewport = *viewport;
#endif
	wsptr->tranudpending = GPENDING;
	(*(dev->wsattributes))(VIEWPORT,wsptr);
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
