/*
 * GKS FUNCTION NAME:  Set Viewport Input Priority
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetviewportpri(transform,reference,priority)
 *        int transform;
 *        int reference;
 *        Gvpri priority;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gsvpip(tnr,rtnr,relpri)
 *        integer tnr
 *        integer rtnr
 *        integer relpri
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Viewport Input Priority";

#ifdef FORTRAN

#define TNR		 	*tnr
#define RTNR	 	*rtnr
#define RELPRI	 	*relpri
#define GSVPIP		gsvpip_

#else

#define TNR			tnr
#define RTNR	 	rtnr
#define RELPRI	 	relpri
#define GSVPIP		gsvpip

#endif

GSVPIP(tnr,rtnr,relpri)
int TNR,RTNR,RELPRI;
{
	int error;
	register struct Gnormtran *nptr,*rptr;

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		error=8;
		goto gkserror;
	}
	if((TNR<0)||(RTNR<0)||(TNR>(NNORMTRAN-1))||(TNR>(NNORMTRAN-1)))
	{
		error=50;
		goto gkserror;
	}
#endif

	nptr = _gks.normtran + TNR;
	rptr = _gks.normtran + RTNR;

	/*
	 * check to see if any changes are needed
	 */
	if((RELPRI == GHIGHER)&&(rptr->higher == nptr))
		return(0);
	if((RELPRI == GLOWER)&&(rptr->lower == nptr))
		return(0);

	/*
	 * else, unlink nptr, checking to see if it is the head of
	 * the list
	 */
	if( _gks.highnormtran == nptr )
		_gks.highnormtran = nptr->lower;
	if(nptr->lower)
		(nptr->lower)->higher = nptr->higher;
	if(nptr->higher)
		(nptr->higher)->lower = nptr->lower;

	/*
	 * relink according to relpri
	 */
	if(RELPRI == GHIGHER)
	{
		nptr->lower = rptr;
		nptr->higher = rptr->higher;
		rptr->higher = nptr;
		if(nptr->higher)
			(nptr->higher)->lower = nptr;
		if(_gks.highnormtran == rptr)
			_gks.highnormtran = nptr;
	}
	else
	{
		nptr->higher = rptr;
		nptr->lower = rptr->lower;
		rptr->lower = nptr;
		if(nptr->lower)
			(nptr->lower)->higher = nptr;
	}
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
