/*
 * GKS FUNCTION NAME:  Set Viewport
 *
 *     C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetviewport(transform,viewport)
 *        int transform;
 *        Glimits *viewport;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gsvp(tnr,xmin,xmax,ymin,ymax)
 *        integer tnr
 *        real xmin,xmax,ymin,yax
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Viewport";

#ifdef FORTRAN

#define XMIN	(*xmin)
#define XMAX	(*xmax)
#define YMIN	(*ymin)
#define YMAX	(*ymax)
#define TNR	 *tnr

gsvp_(tnr,xmin,xmax,ymin,ymax)
register int TNR;
float *xmin,*xmax,*ymin,*ymax;

#else

#define XMIN	(viewport->xmin)
#define XMAX	(viewport->xmax)
#define YMIN	(viewport->ymin)
#define YMAX	(viewport->ymax)
#define TNR tnr

gsvp(tnr,viewport)
register int TNR;
register Glimit *viewport;

#endif
{
	register struct Gnormtran *nptr;
	register int error;

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		error=8;
		goto gkserror;
	}
	if( (TNR < 1) || ( TNR > (NNORMTRAN-1)))
	{
		error=50;
		goto gkserror;
	}
	if((XMIN >= XMAX)|| (YMIN >= YMAX))
	{
		error=51;
		goto gkserror;
	}
	if((XMIN < 0.0) || (YMIN < 0.0) || (XMAX > 1.0) || (YMAX > 1.0))
	{
		error=52;
		goto gkserror;
	}
#endif

	nptr = _gks.normtran + TNR;
#ifdef FORTRAN
	nptr->viewport.xmin = XMIN;
	nptr->viewport.xmax = XMAX;
	nptr->viewport.ymin = YMIN;
	nptr->viewport.ymax = YMAX;
#else
	nptr->viewport = *viewport;
#endif
	gudntran(nptr);
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
