/*
 * GKS FUNCTION NAME:  Select Normalization Transformation
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gselntran(transform)
 *        int transform;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gselnt(tnr)
 *        integer tnr
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Select Normalization Transformation";

#ifdef FORTRAN

#define TNR		 	*tnr
#define GSELNT		gselnt_

#else

#define TNR			tnr
#define GSELNT		gselnt

#endif

GSELNT(tnr)
register int TNR;
{
	int error;

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		error=8;
		goto gkserror;
	}
	if((TNR < 0)||( TNR > (NNORMTRAN-1)))
	{
		error=50;
		goto gkserror;
	}
#endif

	_gks.curnormtran = TNR;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
