/*
 * GKS FUNCTION NAME:  Set Clipping Indicator
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetclip(indicator)
 *        Gclip indicator;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gsclip(ind)
 *        integer ind
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Set Clipping Indicator";

#ifdef FORTRAN

#define GSCLIP	gsclip_
#define IND		*ind

#else

#define GSCLIP	gsclip
#define IND		ind

#endif

GSCLIP(ind)
register int IND;
{

#ifndef FAST
	if(GKS_STATE_ERROR_8)
	{
		gerrorhand(8,name);
		return(8);
	}
#endif

	if(IND)
		_gks.clipind = GCLIP;
	else
		_gks.clipind = GNOCLIP;
	return(0);
}
