/*
 * GKS FUNCTION NAME:  Get Workstation Type
 *
 *  Returns type of graphics workstation that is connected to the 
 *  standard output unit (passed as argument), if any, based on 
 *  /etc/ttywstypes file and WSTYPE environment variable.  If standard
 *  output unit is not a tty line, returns workstation type "vplot".
 *
 *    C SYNTAX:
 *
 *        #include <stdio.h>
 *        #include <gks.h>
 *
 *        typename = ggetwstype(stdfile);
 *
 *	  char *typename, *ggetwstype();
 *        FILE *stdfile;
 *
 *    FORTRAN SYNTAX:
 *
 *        call ggwst(lunit,typnam)
 *
 *        integer lunit
 *	  character typnam*(*)
 *	(declare a character variable at least 15 characters long in
 * the calling program to be sure it can hold the longest possible name).
 *
 */
#include <stdio.h>
#include "gks.h"
#include "f77unit.h"
char _gunknown[]= "unknown";

#ifdef FORTRAN
#define STDFILE		stdfile
#else
#define STDFILE		file
#endif

#ifdef FORTRAN 
ggwst_(lunit,typnam)
int lunit;
char *typnam
#else
char *ggetwstype(file)
FILE *file;
#endif
{
#ifdef FORTRAN
	FILE *stdfile;
	unit *uptr;
#endif
	char *type, *getenv();
	char *ttyid, *ttyname(), *gtypeof();

#ifdef FORTRAN
/*
	units is the fortran logical units table, defined in f77units.h
	Get the corresponding FILE pointer.
*/
	uptr = units+(*lunit);
	stdfile = uptr->ufd;
#endif

	if(ttyid = ttyname(fileno(STDFILE)))
	{
		if(!(type = getenv("WSTYPE")))
		{
			type = gtypeof(ttyid);
		}
	}
	else
	{
		type = "vplot";
	}
#ifdef FORTRAN
	typnam = type;
	return
#else
	return(type);
#endif
}
	

char *
gtypeof(ttyid)
	char *ttyid;
{
	static char typebuf[16];
	char buf[50];
	register FILE *f;
	register char *p, *t, *q;

	if (ttyid == NULL)
		return (_gunknown);
	f = fopen("/etc/ttywstypes", "r");
	if (f == NULL)
		return (_gunknown);
	/* split off end of name */
	for (p = q = ttyid; *p != 0; p++)
		if (*p == '/')
			q = p + 1;

	/* scan the file */
	while (fgets(buf, sizeof buf, f) != NULL)
	{
		for (t = buf; *t != ' ' && *t != '\t'; t++)
			;
		*t++ = 0;
		while (*t == ' ' || *t == '\t')
			t++;
		for (p = t; *p > ' '; p++)
			;
		*p = 0;
		if (strcmp(q,t) == 0)
		{
			strcpy(typebuf, buf);
			fclose(f);
			return (typebuf);
		}
	}
	fclose (f);
	return (_gunknown);
}


