/*
 * GKS FUNCTION NAME:  Evaluate Transformation Matrix
 *
 *     C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gevaltran(fixed,shift,angle,scale,coord,outtran)
 *        Gpoint *fixed;
 *        Gpoint *shift;
 *        float angle;
 *        Gpoint *scale;
 *        int coord;
 *        float outtran[2][3];
 *
 *    FORTRAN SYNTAX:
 *
 *        call gevtm(x0,y0,dx,dy,angle,xscale,yscale,coord,matrix)
 *        real x0,y0
 *        real dx,dy
 *        real angle
 *        real xscale,yscale
 *        integer coord
 *        real matrix(2,3)
 *
 */

#include <stdio.h>
#include <math.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

#ifdef FORTRAN

#define XFIXED *x0
#define YFIXED *y0
#define XSHIFT *dx
#define YSHIFT *dy
#define ANGLE *angle
#define XSCALE *xscale
#define YSCALE *yscale
#define COORD *coord


gevtm_(x0,y0,dx,dy,angle,xscale,yscale,coord,mat)
float XFIXED,YFIXED;
float XSHIFT,YSHIFT;
float ANGLE;
float XSCALE,YSCALE;
int COORD;
float *mat;
{
	float matrix[2][3];

#else

#define XFIXED fixed->x
#define YFIXED fixed->y
#define XSHIFT shift->x
#define YSHIFT shift->x
#define ANGLE angle
#define XSCALE scale->x
#define YSCALE scale->y
#define COORD coord

gevtm(fixed,shift,angle,scale,coord,matrix)
Gpoint *fixed;
register Gpoint *shift;
float ANGLE;
register Gpoint *scale;
int COORD;
float matrix[2][3];
{

#endif
	struct Gnormtran *nptr= _gks.normtran + _gks.curnormtran;
	Gpoint fxp;
	double c,s,cos(),sin();

	/*
	 * transform fixed point to NDC if given in WC
	 */
	if( COORD == GWC)
	{
		fxp.x = (nptr->xscale * XFIXED) + nptr->xshift;
		fxp.y = (nptr->yscale * YFIXED) + nptr->yshift;
	}
	else
	{
		fxp.x = XFIXED;
		fxp.y = YFIXED;
	}

	/*
	 * shift fixed point to origin, scale, rotate,
	 * then shift back to fixed point and apply final shift
	 */
	c = cos((double)(ANGLE));
	s = sin((double)(ANGLE));

	matrix[0][0] = c * XSCALE;
	matrix[1][0] = s * XSCALE;
	matrix[0][1] = -s * YSCALE;
	matrix[1][1] = c * YSCALE;
	matrix[0][2] = -(matrix[0][0] * fxp.x) - (matrix[0][1] * fxp.y)
					+ fxp.x + XSHIFT;
	matrix[1][2] = -(matrix[1][0] * fxp.x) - (matrix[1][1] * fxp.y)
					+ fxp.y + YSHIFT;

#ifdef FORTRAN
	mat[0] = matrix[0][0];
	mat[1] = matrix[1][0];
	mat[2] = matrix[0][1];
	mat[3] = matrix[1][1];
	mat[4] = matrix[0][2];
	mat[5] = matrix[1][2];
#endif
	return(0);
}
