/*
 * GKS FUNCTION NAME:  Accumulate Transformation Matrix
 *
 *     C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gaccumtran(intran,fixed,shift,angle,scale,coord,outtran)
 *        float intran[2][3];
 *        Gpoint *fixed;
 *        Gpoint *shift;
 *        float angle;
 *        Gpoint *scale;
 *        int coord;
 *        float outtran[2][3];
 *
 *    FORTRAN SYNTAX:
 *
 *        call gactm(inmatrix,x0,y0,dx,dy,angle,xscale,yscale,coord,outmatrix)
 *        real x0,y0
 *        real dx,dy
 *        real angle
 *        real xscale,yscale
 *        integer coord
 *        real inmatrix(2,3)
 *        real outmatrix(2,3)
 *
 */

#include <stdio.h>
#include <math.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

#ifdef FORTRAN

gactm_(inmat,x0,y0,dx,dy,angle,xscale,yscale,coord,outmat)
float *x0,*y0;
float *dx,*dy;
float *angle;
float *xscale,*yscale;
int *coord;
float *inmat,*outmat;
{
	float newmat[6];

	gevtm_(x0,y0,dx,dy,angle,xscale,yscale,coord,newmat);
	outmat[0] = (newmat[0] * inmat[0]) + (newmat[2] * inmat[1]);
	outmat[1] = (newmat[1] * inmat[0]) + (newmat[3] * inmat[1]);
	outmat[2] = (newmat[0] * inmat[2]) + (newmat[2] * inmat[3]);
	outmat[3] = (newmat[1] * inmat[2]) + (newmat[3] * inmat[3]);
	outmat[4] = (newmat[0] * inmat[4]) + (newmat[2] * inmat[5]) + newmat[4];
	outmat[5] = (newmat[1] * inmat[4]) + (newmat[3] * inmat[5]) + newmat[5];
	return;
}

#else

gactm(inmat,fixed,shift,angle,scale,coord,outmat)
float inmat[2][3];
Gpoint *fixed;
Gpoint *shift;
float angle;
Gpoint *scale;
int coord;
float outmat[2][3];
{
	float newmat[2][3];

	gevaltran(fixed,shift,angle,scale,coord,newmat);
	outmat[0][0] = (newmat[0][0] * inmat[0][0]) + (newmat[0][1] * inmat[1][0]);
	outmat[1][0] = (newmat[1][0] * inmat[0][0]) + (newmat[1][1] * inmat[1][0]);
	outmat[0][1] = (newmat[0][0] * inmat[0][1]) + (newmat[0][1] * inmat[1][1]);
	outmat[1][1] = (newmat[1][0] * inmat[0][1]) + (newmat[1][1] * inmat[1][1]);
	outmat[0][2] = (newmat[0][0] * inmat[0][2]) + (newmat[0][1] * inmat[1][2])
					+ newmat[0][2];
	outmat[1][2] = (newmat[1][0] * inmat[0][2]) + (newmat[1][1] * inmat[1][2])
					+ newmat[1][2];
	return(0);
}
#endif
