/*
 * GKS FUNCTION NAME:  Set Visibility
 *
 *     C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetvis(segment,visibility)
 *        int segment;
 *        int visibility;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gsvis(sgna,vis)
 *        integer sgna
 *        integer vis
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "metafile.h"
#include "extern.h"

#ifdef FORTRAN

#define GSVIS	gsvis_
#define	SEG		*segment
#define	VIS		*visibility

#else

#define GSVIS	gsvis
#define	SEG		segment
#define	VIS		visibility

#endif

GSVIS(segment,visibility)
int SEG;
int VIS;
{
	register int i;
	register Gdevsw *dev;
	register Gwsstatelist *wsptr;

	for( i=0; i < NWORKSTATION; i++)
	{
		if( wsptr = _gks.workstation[i])
		{
			if( wsptr->isactive )
			{
				dev = _gdevsw + gmajordev(wsptr->type);
				(*(dev->segattributes))(VISIBILITY,wsptr,SEG,&(VIS));
			}
		}
	}
}
