/*
 * GKS FUNCTION NAME:  Set Segment Transformation
 *
 *     C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gsetsegtran(segment,transform)
 *        int segment;
 *        float transform[2][3];
 *
 *    FORTRAN SYNTAX:
 *
 *        call gssgt(sgna,matrix)
 *        integer sgna
 *        real matrix(2,3)
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

#ifdef FORTRAN


gssgt_(sgna,matrix)
int *sgna;
float *matrix;
{
	_segtran[0][0] = matrix[0];
	_segtran[1][0] = matrix[1];
	_segtran[0][1] = matrix[2];
	_segtran[1][1] = matrix[3];
	_segtran[0][2] = matrix[4];
	_segtran[1][2] = matrix[5];

	return;
}
		
#else

gssgt(segment,transform)
int segment;
float transform[2][3];
{
	register float *mptr = (float *)transform;

	_segtran[0][0] = transform[0][0];
	_segtran[0][1] = transform[0][1];
	_segtran[0][2] = transform[0][2];
	_segtran[1][0] = transform[1][0];
	_segtran[1][1] = transform[1][1];
	_segtran[1][2] = transform[1][2];

	return(0);
}
#endif
