/*
 * GKS FUNCTION NAME:  Create Segment 
 *
 *     C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gcreateseg(segment)
 *        int segment;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gcrsg(sgna)
 *        integer sgna
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "metafile.h"
#include "extern.h"

#ifdef FORTRAN

#define GCRSG	gcrsg_
#define	SEG		*segment

#else

#define GCRSG	gcrsg
#define	SEG		segment

#endif

GCRSG(segment)
int SEG;
{
	register int i;
	register Gdevsw *dev;
	register Gwsstatelist *wsptr;

	for( i=0; i < NWORKSTATION; i++)
	{
		if( wsptr = _gks.workstation[i])
		{
			if( wsptr->isactive )
			{
				dev = _gdevsw + gmajordev(wsptr->type);
				(*(dev->segcontrol))(CREATE,wsptr,SEG);
			}
		}
	}
	_gks.openseg = SEG;
}
