/*
 * GKS FUNCTION NAME:  Close Segment 
 *
 *     C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gcloseseg()
 *
 *    FORTRAN SYNTAX:
 *
 *        call gclsg()
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "metafile.h"
#include "extern.h"

#ifdef FORTRAN

#define GCLSG	gclsg_

#else

#define GCLSG	gclsg

#endif

GCLSG()
{
	register int i;
	register Gdevsw *dev;
	register Gwsstatelist *wsptr;

	for( i=0; i < NWORKSTATION; i++)
	{
		if( wsptr = _gks.workstation[i])
		{
			if( wsptr->isactive )
			{
				dev = _gdevsw + gmajordev(wsptr->type);
				(*(dev->segcontrol))(CLOSE,wsptr,_gks.openseg);
			}
		}
	}
}
