#include <stdio.h>
#include "gks.h"

#define PI 3.14159265
#define SEGMENT		1
#define SCREEN		1
double sin();

main()
{
	register int i;
	int mark,ntn,status;
	char *wstype, *ggetwstype(), *strcmp();
	Gpoint curve[101],frame[5],diag[2],xline[2],yline[2];
	Gpoint vec,fix,scale;
	Glimit window[4],viewport[4],wswindow;
	Gtxalign align;
	Gloc loc;
	Gqloc locresp;
	float transform[2][3];
	float angle;
	FILE *errorfile;

	for(i=0; i<101; i++)
	{
		curve[i].x = (i * 0.2) - 10.0;
		curve[i].y = 4.0 * sin( (double)curve[i].x);
	}

	/*
	 * open GKS and a workstation
	 */
	errorfile = fopen("gks.error.log","w");
	gopengks(1000,errorfile);
	wstype = ggetwstype(stdout);

	if(!strcmp(wstype,"unknown"))
	{
		fprintf(stderr,"Terminal is an unknown workstation type\n");
		exit(0);
	}
	gopenws(SCREEN,stdout,wstype);
	gactivatews(SCREEN);

	/*
	 * set up windows and viewports
	 */
	window[1].xmin = -7.0; window[1].ymin = -7.0;
	window[1].xmax =  7.0; window[1].ymax =  7.0;
	gsetwindow(1,window+1);

	viewport[1].xmin = .1; viewport[1].ymin = .2;
	viewport[1].xmax = .6; viewport[1].ymax = .7;
	gsetviewport(1,viewport+1);

	window[2].xmin = -1.0; window[2].ymin = -1.0;
	window[2].xmax =  5.0; window[2].ymax =  5.0;
	gsetwindow(2,window+2);

	viewport[2].xmin = .65; viewport[2].ymin = .475;
	viewport[2].xmax = .90; viewport[2].ymax = .725;
	gsetviewport(2,viewport+2);

	window[3].xmin = -1.5; window[3].ymin = -1.5;
	window[3].xmax =  1.5; window[3].ymax =  1.5;
	gsetwindow(3,window+3);

	viewport[3].xmin = .65; viewport[3].ymin = .175;
	viewport[3].xmax = .90; viewport[3].ymax = .425;
	gsetviewport(3,viewport+3);

	wswindow.xmin = 0.; wswindow.ymin = 0.;
	wswindow.xmax = 1.; wswindow.ymax = 1.;
	makeabox(&wswindow,frame);

	for(;;)
	{
		gsetclip(GNOCLIP);
		gselntran(0);
		gsetcharheight(0.015);
		align.hor = GTH_CENTER ; align.ver = GTV_BASE;
		gsettextalign(&align);
		vec.x = 0.5; vec.y = 0.80;
		diag[0].x = 0.5; diag[1].x = 0.5; diag[0].y = 0.75; diag[1].y=0.85;
		gsetlinewidth(4.0);
		gpolyline(2,diag);
		diag[0].x = 0.45; diag[1].x = 0.55; diag[0].y = 0.8; diag[1].y=0.8;
		gpolyline(2,diag);
		gtext(&vec,"Title");

		gsetlinewidth(1.0);
		gsetlinetype(1);
		gpolyline(5,frame);
		for(i=1; i<4; i++)
		{
			gsetlinetype(i);
			gsetlinecolorind(i+1);
			if((i == 2)||(i == 3))
			{
				gselntran(1);
				makeabox(window+i,frame);
				gpolyline(5,frame);
				gselntran(0);
			}
			makeabox(viewport+i,frame);
			gpolyline(5,frame);
		}

		fix.x = 0.; fix.y = 0.;
		scale.x = 1.0; scale.y = 1.0;
		gsetlinetype(1);
		gsetlinecolorind(5);
		gsetmarkercolorind(5);
		gsetmarkersize(2.1);
		gsetmarkertype(3);
		gsetclip(GCLIP);
		for(angle=0.; angle<3.0; angle+=(PI/8.))
		{
			for(i=1; i<4; i++)
			{
				gselntran(i);
				gevaltran(&fix,&fix,angle,&scale,GWC,transform);
				gsetsegtran(SEGMENT,transform);
				gpolyline(101,curve);
			}
		}

		gevaltran(&fix,&fix,0.0,&scale,GWC,transform);
		gsetsegtran(SEGMENT,transform);
	
		/*
		 * ask for input
		 */
		gselntran(0);
		loc.transform = 0;
		loc.position.x = 0.5; loc.position.y=0.5;
		ginitloc(SCREEN,1,&loc,1,0,0);
		greqloc(SCREEN,1,&locresp);
		if( locresp.status == GNONE)
		{
			wswindow.xmin = 0.; wswindow.ymin = 0.;
			wswindow.xmax = 1.; wswindow.ymax = 1.;
			makeabox(&wswindow,frame);
			gsetlinecolorind(6);
			gsetlinetype(1);
		}
		else
		{
			gsetlinetype(1);
			gsetlinecolorind(6);
			xline[0].x = xline[1].x = locresp.loc.position.x;
			xline[0].y = 0.;xline[1].y = 1.;
			gpolyline(2,xline);
			yline[0].y = yline[1].y = locresp.loc.position.y;
			yline[0].x = 0.;yline[1].x = 1.;
			gpolyline(2,yline);
			
			loc = locresp.loc;
			ginitloc(SCREEN,1,&loc,1,0,0);
			greqloc(SCREEN,1,&locresp);

			align.hor = GTH_LEFT; align.ver = GTV_BOTTOM;
			gsettextalign(&align);

			gsetlinecolorind(0);
			gpolyline(2,xline);
			gpolyline(2,yline);
			/*
			 * sort out window
			 */
			if(locresp.loc.position.x < xline[0].x)
			{
				wswindow.xmin = locresp.loc.position.x;
				wswindow.xmax = xline[0].x;
			}
			else
			{
				wswindow.xmin = xline[0].x;
				wswindow.xmax = locresp.loc.position.x;
			}
			if(locresp.loc.position.y < yline[0].y)
			{
				wswindow.ymin = locresp.loc.position.y;
				wswindow.ymax = yline[0].y;
			}
			else
			{
				wswindow.ymin = yline[0].y;
				wswindow.ymax = locresp.loc.position.y;
			}
			yline[0].x = wswindow.xmin;
			yline[0].y = wswindow.ymax;
			gtext(yline,"Next Workstation Window");

			gsetlinecolorind(6);
			gsetlinewidth(6.0);
			makeabox(&wswindow,frame);
			gpolyline(5,frame);
			vec.x = 0.; vec.y = 0.;
			gsetlinewidth(1.0);

			ginitloc(SCREEN,1,&loc,1,0,0);
			greqloc(SCREEN,1,&locresp);
		}

		gsetwswindow(SCREEN,&wswindow);
		gclearws(SCREEN);
	}
	
}

makeabox(rectangle,points)
Glimit *rectangle;
Gpoint points[];
{
	points[3].x = points[0].x = points[4].x = rectangle->xmin;
	points[1].y = points[0].y = points[4].y = rectangle->ymin;
	points[1].x = points[2].x = rectangle->xmax;
	points[3].y = points[2].y = rectangle->ymax;
}
