#define BIN "/usr/local"

char *documentation[] = {
"",
"",
"",
" NAME",
"       tube - display a vplot file on a graphics terminal",
" SYNTAX",
"       tube -[flags] [parameters] [inputfiles]",
" PARAMETERS",
"       wstype=[string]",
"               Specify workstation type.  Useful for directing output to",
"               a screen other than the control terminal, or to a file.",
"       other parameters, as described in the manual entry for pen(L)",
" SYNOPSIS",
"       Tube displays files of vplot commands.  To use it, you must",
"       be sitting at a graphics terminal, and tube must know what",
"       type of terminal it is.  If you've logged in over the Ethernet",
"       or the phone, use 'setenv WSTYPE termtype' to tell Unix your",
"       graphics workstation type.",
" SEE ALSO",
"       pen(L), vplot(L)",
" AUTHOR",
"       Chuck Karish"
};
int     doclength = { sizeof documentation/sizeof documentation[0] };

static struct terms {
	char termtype[26];
	char filter[26];
	char desc[51];
} termlist[] = {
	{ "dscan",		"tekpen",	"Seiko D-Scan" },
	{ "envi215",	"envipen",	"Envision 215" },
	{ "envision",	"envipen",	"Envision 220, 230" },
	{ "gigi",		"gigipen",	"DEC gigi" },
	{ "graphon",	"tekpen",	"GraphOn 100, 200 series"},
	{ "retrographics","tekpen","DEC or Televideo with Retrographics board" },
	{ "selanar",	"tekpen",	"Selanar Hi-Rez 100" },
	{ "tek4010",	"tekpen",	"Tektronix 4010 or emulator" },
	{ "tek4012",	"tekpen",	"Tektronix 4012 or emulator" },
	{ "tek4013",	"tekpen",	"Tektronix 4013 or emulator" },
	{ "tek4014",	"tekpen",	"Tektronix 4014 or emulator" },
	{ "tek4105",	"ctekpen",	"Tektronix 4105, 4106, or emulator" },
	{ "tek4107",	"ctekpen",	"Tektronix 4107, 4109, or emulator" },
	{ "tgraf",		"ctekpen",	"Grafpoint Tgraf-05 or Tgraf-07 on IBM PC" },
	{ "vplot",		"pchain",	"vplot to vplot filter" },
	{ "vt125",		"gigipen",		"DEC VT125"},
	{ "xwindows",	"xpen",		"XWindows server" }
};
int numtypes = (int)(sizeof(termlist)/sizeof(struct terms));

