/*
 *  tube.c - vplot display program
 *              compile with GKS library to get the 'ggetwstype' function
 *              written by Chuck Karish, 25 Nov 1986
 */

/* static char name[] = "tube"; */

#include <stdio.h>
#include <sys/ioctl.h>
#include <sgtty.h>
#include <strings.h>
#include "tube.h"

int xargc;
char **xargv;
struct sgttyb ttystat;

main(argc,argv)
int argc;
char *argv[];
{
	int ii = 0;
	char *wstype, *cptr;
	extern struct terms termlist[];
	extern char *ggetwstype();
	int piped_in;

	xargc = argc;
	xargv = argv;
	piped_in = ioctl ((fileno (stdin)), TIOCGETP, (char *)&ttystat);

/*
 *  find out what type of graphics terminal the output is directed to
 */
	wstype = ggetwstype(stdout);
		
/*
 *  read the command line
 */
	for (xargc--,xargv++; xargc; xargc--,xargv++)
	{
/*
 *  if "wstype=" commandline argument, override wstype returned by ggetwstype()
 */
		if(!strncmp( *xargv, "wstype=", 7))
		{
			wstype = rindex(*xargv, '=');
			++wstype;
			if (argc==2) --argc;
		}
	}
	xargv = argv;
	xargc = argc;
	if (argc == 1 && !(piped_in))
	{
		selfdoc();
	}

/*
 *  find the name of the proper filter, and execute it
 */
	for (ii=0; ii< numtypes; ++ii)
	{
		if (!strcmp(wstype, termlist[ii].termtype))
			plotit(wstype, termlist[ii].filter);
	}

/*
 *	'tube' shold exit from plotit().
 *  if we get to this point, we haven't found a filter to execve.
 */
	fprintf(stderr,
	"tube: couldn't find an output filter for your display.\n\n");
	fprintf(stderr,
"syntax: tube [wstype=termtype] [in=inputfile] [inputfile [inputfile]]\n\n");
}

plotit(wstype, filter)		
char *wstype, filter[];
{
	/* xargc, xargv must be set to argc, argv before calling plotit! */
	extern char **environ;
	char string[125], string2[125], **av;

	/* set up a new argument vector, with one more parameter (wstype=) */
	av = (char **)calloc(xargc + 2, sizeof(long));
	/* write out the full pathname of the output filter */
	sprintf(string, "%s/%s", BIN, filter);
	sprintf(string2, "wstype=%s", wstype);
	av = xargv;
	av += xargc;
	*av = string2;
	av++;
	*av = NULL;
	av -= xargc+1;

	/* do it */
	execve((char *)string, av, environ);
	exit(0);
}

selfdoc()
{
	char string[80];
	int ii;
	extern struct terms termlist[];
	for( ii=0; ii<doclength; ii++)
		printf("%s\n",documentation[ii]);
	printf(
   "\nType 't' for more documentation, 's' to run a filter, or <CR> to quit: ");
	fflush(stdout);
	gets(string);
	switch (string[0]){
		case 't':
		case 'T':
			ii = listterms(string[0]);
			sprintf(string, "%s%s", BIN, termlist[ii].filter);
			execl(string, "selfdoc=y", 0);
			break;
		case 's':
		case 'S':
			ii = listterms(string[0]);
			plotit(termlist[ii].termtype, termlist[ii].filter);
			break;
		default:
			exit(0);
			break;
			
	}
	exit(0);
}

listterms(flag)
char flag;
{
	int jj;
	char string[80];
	extern struct terms termlist[];
	extern int numtypes;

	printf("\n\n\n\n %27s  %-50s\n\n", "wstype", "terminal");
	jj = 0;
	for (jj=0; jj<numtypes; ++jj)
	{
		printf("%2d %25s  %-50s\n",
			jj+1, termlist[jj].termtype, termlist[jj].desc);
	}
	if (flag=='t' || flag=='T')
	printf
	("\n\nType a line number for information about a filter, or <CR> to quit: ");
	else if (flag=='s' || flag=='S')
		printf ("\n\nType a line number to run a filter, or <CR> to quit: ");
	gets(string);
	if (!strcmp(string, ""))
		exit(0);
	jj = atoi(string);
	if (jj<=0 || jj>numtypes)
	{
		fprintf(stderr,"tube: bad terminal type number.\n");
		fflush(stderr);
		exit(1);
	}
	return(jj - 1);
}
