#include <stdio.h>
#include "gks.h"

#define EVER ;;

/*
 * we will use 2 workstations named:
 */
#define SCREENWS	1
#define HARDCOPYWS	2

/*
 * we will use normalization transforms for the drawing window and to
 * generate the menus
 */
#define DRAWNT		2
#define COLORNT		3
#define LINENT		4
#define CLEARNT		5
#define PRINTNT		6
#define QUITNT		7

/*
 * NDC viewports for the screen regions
 */
Glimit drawvp = { 0.,.85,0.,.65};
Glimit colorvp = { 0.,.65,.65,.74};
Glimit colorwn = { 1.,8.,0.,1.0};
Glimit linevp = { .85,.99,0.,.65};
Glimit linewn = { -0.25,1.25,1.,9.};
Glimit quitvp = {.85,.99,.65,.74};
Glimit clearvp = {.75,.85,.65,.74};
Glimit printvp = {.65,.75,.65,.74};

/*
 * workstation windows for the screen and hardcopy;
 * hardcopy unit only sees the drawing window.
 */
Glimit screenwswindow = {0.,1.,0.,.75};
Glimit hardcopywswindow = { 0.,.8,0.,.65};

main()
{
	char *wstype, *ggetwstype(), *strcmp();
	FILE *errorfile;
	int penup;
	Gpoint line[2];
	Gloc loc;
	Gqloc locresp;

	/*
	 * open GKS and the screen workstation
	 */
	errorfile = fopen("gksdraw.log","w");
	gopengks(1000,errorfile);
	wstype = ggetwstype(stdout);

	if(!strcmp(wstype,"unknown"))
	{
		fprintf(stderr,"Terminal is an unknown workstation type\n");
		exit(0);
	}
	gopenws(SCREENWS,stdout,wstype);
	gactivatews(SCREENWS);
	gsetwswindow(SCREENWS,&screenwswindow);

	/*
	 * set up the normalization transforms
	 */
	gsetviewport(DRAWNT,&drawvp);
	gsetviewport(COLORNT,&colorvp);
	gsetwindow(COLORNT,&colorwn);
	gsetviewport(LINENT,&linevp);
	gsetwindow(LINENT,&linewn);
	gsetviewport(CLEARNT,&clearvp);
	gsetviewport(PRINTNT,&printvp);
	gsetviewport(QUITNT,&quitvp);

	
	/*
	 * set viewport input priorities
	 */
	gsetviewportinputpri(QUITNT,0,GHIGHER);
	gsetviewportinputpri(CLEARNT,0,GHIGHER);
	gsetviewportinputpri(COLORNT,0,GHIGHER);
	gsetviewportinputpri(LINENT,0,GHIGHER);
	gsetviewportinputpri(DRAWNT,0,GHIGHER);


	draw_menus();

	locresp.loc.transform = DRAWNT;
	locresp.loc.position.x = 0.5;
	locresp.loc.position.y = 0.5;
	penup = 1;

	for(EVER)
	{
		loc = locresp.loc;
		ginitloc(SCREENWS,1,&loc,1,0,0);
		greqloc(SCREENWS,1,&locresp);

		if( locresp.status == GNONE)
		{
			penup = 1;
			locresp.loc.transform = DRAWNT;
			locresp.loc.position.x = 0.5;
			locresp.loc.position.y = 0.5;
		}
		else
		{
			switch(locresp.loc.transform)
			{
			case DRAWNT:
				if(penup)
				{
					line[0].x = locresp.loc.position.x;
					line[0].y = locresp.loc.position.y;
					penup=0;
				}
				else
				{
					line[1].x = locresp.loc.position.x;
					line[1].y = locresp.loc.position.y;
					gpolyline(2,line);
					line[0].x = line[1].x;
					line[0].y = line[1].y;
				}
				break;
			case LINENT:
				if(locresp.loc.position.y < 5.0)
				{
					gsetlinetype( (int)locresp.loc.position.y);
					gsetlinewidth(1.0);
				}
				else
				{
					gsetlinewidth( locresp.loc.position.y - 3.5);
				}
				penup=1;
				break;
			case COLORNT:
				gsetlinecolorind( (int)locresp.loc.position.x);
				penup=1;
				break;
			case QUITNT:
				gdeactivatews(SCREENWS);
				gclosews(SCREENWS);
				exit(0);
			case CLEARNT:
				gclearws(SCREENWS);
				draw_menus();
			default:
				penup=1;
				locresp.loc.transform = DRAWNT;
				locresp.loc.position.x = 0.5;
				locresp.loc.position.y = 0.5;
			}
		}
	}
}

draw_menus()
{
	float x,y;
	Gpoint vec;
	Gpoint line[2];
	Gpoint frame[5];
	Gtxalign align;
	gselntran(0);

	gsetlinecolorind(7);
	gsetlinetype(1);
	gsetlinewidth(1.0);

	frame[3].y = frame[2].y = screenwswindow.ymax-0.01;
	frame[1].x = frame[2].x = screenwswindow.xmax-0.01;
	frame[1].y = frame[0].y = frame[4].y = screenwswindow.ymin;
	frame[3].x = frame[0].x = frame[4].x = screenwswindow.xmin;

	gpolyline(5,frame);

	line[0].x = frame[0].x; line[1].x = frame[1].x;
	line[0].y = line[1].y = quitvp.ymin;
	gpolyline(2,line);
	
	line[0].y = frame[2].y; line[1].y = frame[0].y;
	line[0].x = line[1].x = quitvp.xmin;
	gpolyline(2,line);

	line[1].y = clearvp.ymin;
	line[0].x = line[1].x = clearvp.xmin;
	gpolyline(2,line);
	line[0].x = line[1].x = printvp.xmin;
	gpolyline(2,line);

	vec.x = 0.5; vec.y = 0.5;
	align.hor = GTH_CENTER; align.ver = GTV_HALF;
	gsettextalign(&align);
	gselntran(CLEARNT);
	gtext(&vec,"ERASE");
	gselntran(PRINTNT);
	gtext(&vec,"PRINT");
	gselntran(QUITNT);
	gtext(&vec,"QUIT");

	gselntran(COLORNT);
	line[0].y = 0.; line[1].y = 1.0;
	vec.y = 0.5;
	gsetmarkertype(3);
	gsetmarkersize(3.0);
	for(x=1.; x<8.; x += 1.)
	{
		line[0].x = line[1].x = x;
		gpolyline(2,line);
		vec.x = x + 0.5;
		gsetmarkercolorind( (int)x);
		gpolymarker(1,&vec);
	}

	gselntran(LINENT);
	line[0].x = 0.; line[1].x = 1.0;
	for(y=1.5; y<5.; y += 1.)
	{
		line[0].y = line[1].y = y;
		gsetlinetype( (int)y);
		gpolyline(2,line);
	}
	gsetlinetype(1);
	for(y=5.5; y<9.; y += 1.)
	{
		line[0].y = line[1].y = y;
		gsetlinewidth( y - 3.5 );
		gpolyline(2,line);
	}
	gsetlinewidth(1.0);
	gselntran(DRAWNT);
}
