#include	"grafix.h"
#include	"graphics.h"
#include	<stdio.h>
#include	<math.h>

/*
 *---------------------------------------------------------------
 * clip_seg3()
 *---------------------------------------------------------------
 * clip the segment to the current 3D window in screen coordinates
 * uses "window-edge" coordinates and Cohen-Sutherland outcodes
 *
 * the two user supplied endpoints are moved to the window boundaries
 * and a flag is returned indicating the results of the clipping:
 *	flag = 0 .... segement was trivially accepted
 *	       1 .... first endpoint was adjusted
 *		   2 .... second endpoint was adjusted
 *		   3 .... both endpoints were adjusted
 *		  -1 .... segment was trivially rejected
 *
 * if the argument "depth" is non-zero then depth clipping is enabled
 *
 * N.B. the user supplied endpoints are modified so don't give the
 *      routine the current point directly
 */

clip_seg3( pt1, pt2, front, back)

int front, back;
gwpoint4 *pt1,*pt2;
{
	register int code1= 0;
	register int code2= 0;
	register int i;
	register float *w1 = wc1;
	register float *w2 = wc2;
	int flag;
	float wc1[6],wc2[6],t1,t2,t;
	gwpoint4 dvar;

	wc1[0] = pt1.w + pt1.x;  wc2[0] = pt2.w + pt2.x;
	wc1[1] = pt1.w - pt1.x;  wc2[1] = pt2.w - pt2.x;
	wc1[2] = pt1.w + pt1.y;  wc2[2] = pt2.w + pt2.y;
	wc1[3] = pt1.w - pt1.y;  wc2[3] = pt2.w - pt2.y;

	wc1[4] = pt1.z;  wc2[4] = pt2.z;

	if (back){
		wc1[5] = pt1.w - pt1.z;  wc2[5] = pt2.w - pt2.z;
	}

	w1 = wc1;  w2 = wc2;
	for(i=0; i<4; i++){
		if( *w1++ < 0.0 ) code1 |= (01 << i);
		if( *w2++ < 0.0 ) code2 |= (01 << i);
	}
	if(front){
		if( *w1 < 0.0 ) code1 |= (01 << i);
		if( *w2 < 0.0 ) code2 |= (01 << i);
	}
	if(back){
		w1++; w2++;
		if( *w1 < 0.0 ) code1 |= (01 << i);
		if( *w2 < 0.0 ) code2 |= (01 << i);
	}

	flag = 0;
	w1 = wc1;  w2 = wc2;
	
	if ( code1 || code2 )
	{
		if ( !(code1 & code2) )
		{
			t1 = 0.;  t2 = 1.;
			for(i=0; i<4; i++)
			{
				if(*w1 < 0. || *w2 < 0.)
				{
					t = *w1/(*w1 - *w2);
					if( *w1 < 0.)
					{
						if( t > t1) t1 = t;
					}
					else
					{
						if( t < t2) t2 = t;
					}
				}
				w1++; w2++;
			}
			if(front)
			{
				if(*w1 < 0. || *w2 < 0.)
				{
					t = *w1/(*w1 - *w2);
					if( *w1 < 0.)
					{
						if( t > t1) t1 = t;
					}
					else
					{
						if( t < t2) t2 = t;
					}
				}
			}
			if(back)
			{
				w1++; w2++;
				if(*w1 < 0. || *w2 < 0.)
				{
					t = *w1/(*w1 - *w2);
					if( *w1 < 0.){
						if( t > t1) t1 = t;
					}
					else
					{
						if( t < t2) t2 = t;
					}
				}
			}


			if( t2 > t1 )
			{
				dvar.x	= pt2.x - pt1.x;
				dvar.y	= pt2.y - pt1.y;
				dvar.z	= pt2.z - pt1.z;
				dvar.w	= pt2.w - pt1.w;
				if( t2 != 1.){
					flag |= 2;
					pt2.x = pt1.x + (t2 * dvar.x);
					pt2.y = pt1.y + (t2 * dvar.y);
					pt2.z = pt1.z + (t2 * dvar.z);
					pt2.w = pt1.w + (t2 * dvar.w);
				}
				if( t1 ){
					flag |= 1;
					pt1.x = pt1.x + (t1 * dvar.x);
					pt1.y = pt1.y + (t1 * dvar.y);
					pt1.z = pt1.z + (t1 * dvar.z);
					pt1.w = pt1.w + (t1 * dvar.w);
				}
			}
			else flag = -1;
		}
		else flag = -1;
 	}
	return (flag);
}
