/*
 * GKS FUNCTION NAME:  Text
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gtext(pos,string)
 *        Gpoint *pos;
 *        char *string;
 *
 *
 *
 *    FORTRAN SYNTAX:
 *
 *        call gtx(x,y,string)
 *        real x,y
 *        character string
 *
 */

#include <stdio.h>
#include <math.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Text";

#ifdef FORTRAN

#define X (*x)
#define Y (*y)

gtx_(x,y,string)
float *x;
float *y;

#else

#define X (pos->x)
#define Y (pos->y)

gtx(pos,string)
Gpoint *pos;

#endif

char *string;
{
	Gpoint point;
	struct Gnormtran *nptr= _gks.normtran + _gks.curnormtran;
	Gtxcontrol txcontrol;
	register int i;
	register Gdevsw *dev;
	register Gwsstatelist *wsptr;


	/*
	 * transform charup*charheight and baseline
	 */
	txcontrol.tc_up.x = ( _gks.charheight * _gks.charup.x) * nptr->xscale;
	txcontrol.tc_up.y = ( _gks.charheight * _gks.charup.y) * nptr->yscale;
	txcontrol.tc_path.x = ( _gks.charheight * _gks.charup.y) * nptr->xscale;
	txcontrol.tc_path.y = -( _gks.charheight * _gks.charup.x) * nptr->yscale;

	txcontrol.tc_index = _gks.curtextindex;
	txcontrol.tc_align = _gks.textalign;
	txcontrol.tc_individual = _gks.curtext;
	txcontrol.tc_segtran = &(_segtran[0][0]);
	if(_gks.clipind)
		txcontrol.tc_cliprect = &(nptr->viewport);
	else
		txcontrol.tc_cliprect = 0;

	point.x = X * nptr->xscale + nptr->xshift;
	point.y = Y * nptr->yscale + nptr->yshift;

	for( i=0; i < NWORKSTATION; i++)
	{
		if( wsptr = _gks.workstation[i])
		{
			if( wsptr->isactive )
			{
				dev = _gdevsw + gmajordev(wsptr->type);
				(*(dev->text))(&point,string,&txcontrol,wsptr);
			}
		}
	}
	return(0);
}
