/*
 * GKS FUNCTION NAME:  Polymarker
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gpolymarker(npts,points)
 *        int npts;
 *        Gpoint points[];
 *
 *    FORTRAN SYNTAX:
 *
 *        call gpm(npts,x,y)
 *        integer npts
 *        real x(),y()
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Polymarker";

extern int _ptsbuflen;
extern char *_ptsbuf;
extern char *malloc();

#ifdef FORTRAN

#define X (*xp)
#define Y (*yp)
#define XYINC  xp++;yp++
#define NPTS *npts

gpm_(npts,x,y)
int NPTS;
float *x,*y;
{
	register int i = NPTS;
	register float *xp=x;
	register float *yp=y;

#else

#define X		(p->x)
#define Y		(p->y)
#define XYINC 	p++
#define NPTS npts

gpm(npts,points)
int NPTS;
Gpoint *points;
{
	register int i = NPTS;
	register Gpoint *p=points;

#endif

	struct Gnormtran *nptr= _gks.normtran + _gks.curnormtran;
	register Gpoint *pptr;
	register Gdevsw *dev;
	Gwsstatelist *wsptr;
	Gmkcontrol mkcontrol;
	int error;

	if(NPTS > 0)
	{
		if( NPTS > _ptsbuflen)
		{
			if(_ptsbuf) free(_ptsbuf);
			_ptsbuf = malloc( NPTS * sizeof(Gpoint));
			_ptsbuflen = NPTS;
		}
		pptr = (Gpoint *)_ptsbuf;
		while(i--)
		{
			pptr->x = X * nptr->xscale + nptr->xshift;
			pptr->y = Y * nptr->yscale + nptr->yshift;
			XYINC; pptr++;
		}

		mkcontrol.mc_index = _gks.curmarkerindex;
		mkcontrol.mc_individual = _gks.curmarker;
		mkcontrol.mc_segtran = &(_segtran[0][0]);
		if(_gks.clipind)
			mkcontrol.mc_cliprect = &(nptr->viewport);
		else
			mkcontrol.mc_cliprect = 0;
	
		for( i=0; i < NWORKSTATION; i++)
		{
			if( wsptr = _gks.workstation[i])
			{
				if( wsptr->isactive )
				{
					dev = _gdevsw + gmajordev(wsptr->type);
					(*(dev->polymarker))(NPTS,_ptsbuf,&mkcontrol,wsptr);
				}
			}
		}
		return(0);
	}
	else
		error=100;
	gerrorhand(error,name);
	return(error);
}
