/*
 * GKS FUNCTION NAME:  Polyline
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        gpolyline(npts,points)
 *        int npts;
 *        Gpoint points[];
 *
 *    FORTRAN SYNTAX:
 *
 *        call gpl(npts,x,y)
 *        integer npts
 *        real x(),y()
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "extern.h"

static char *name="Polyline";

int _ptsbuflen;
char *_ptsbuf;
char *malloc();

#ifdef FORTRAN

#define X (*xp)
#define Y (*yp)
#define XYINC  xp++;yp++
#define NPTS *npts

gpl_(npts,x,y)
int NPTS;
float *x,*y;
{
	register int i = NPTS;
	register float *xp=x;
	register float *yp=y;

#else

#define X		(p->x)
#define Y		(p->y)
#define XYINC 	p++
#define NPTS npts

gpl(npts,points)
int NPTS;
Gpoint *points;
{
	register int i = NPTS;
	register Gpoint *p=points;

#endif

	struct Gnormtran *nptr= _gks.normtran + _gks.curnormtran;
	register Gpoint *pptr;
	register Gdevsw *dev;
	Gwsstatelist *wsptr;
	Glncontrol lncontrol;
	int error;

	if(NPTS > 1)
	{
		if( NPTS > _ptsbuflen)
		{
			if(_ptsbuf) free(_ptsbuf);
			_ptsbuf = malloc( NPTS * sizeof(Gpoint));
			_ptsbuflen = NPTS;
		}
		pptr = (Gpoint *)_ptsbuf;
		while(i--)
		{
			pptr->x = X * nptr->xscale + nptr->xshift;
			pptr->y = Y * nptr->yscale + nptr->yshift;
			XYINC; pptr++;
		}

		lncontrol.lc_index = _gks.curlineindex;
		lncontrol.lc_individual = _gks.curline;
		lncontrol.lc_segtran = &(_segtran[0][0]);
		if(_gks.clipind)
			lncontrol.lc_cliprect = &(nptr->viewport);
		else
			lncontrol.lc_cliprect = 0;
	
		for( i=0; i < NWORKSTATION; i++)
		{
			if( wsptr = _gks.workstation[i])
			{
				if( wsptr->isactive )
				{
					dev = _gdevsw + gmajordev(wsptr->type);
					(*(dev->polyline))(NPTS,_ptsbuf,&lncontrol,wsptr);
				}
			}
		}
		return(0);
	}
	else
		error=100;
	gerrorhand(error,name);
	return(error);
}
