/*
 * GKS FUNCTION NAME:  Inquire Workstation State
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        ginqwsstate(ws,state)
 *        int ws;
 *        int *state;
 *
 *    FORTRAN SYNTAX:
 *
 *        call gqwks(wkid,errind,state)
 *        integer wkid,errind,state
 *
 */

#include <stdio.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "wstable.h"
#include "extern.h"
#include "metafile.h"

#ifdef FORTRAN

#define WS		*ws
gqwks_(ws,errind,state)
register int WS;
int *errind;

#else

#define WS		ws
gqwks(ws,state)
register int WS;

#endif
int *state;
{
	register Gwsstatelist *wsptr;
	int error;

	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error=20;
	}
	else
	{
		wsptr = _gks.workstation[WS];
		if( !wsptr) 
		{
			error=25;
		}
		else
		{
			if(wsptr->isactive)
				*state = GACTIVE;
			else
				*state = GINACTIVE;
		}
	}
#ifdef FORTRAN
	*errind = error;
	return;
#else
	return(error);
#endif
}
