/*
 * GKS FUNCTION NAME:  Inquire Text Font and Precision
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        ginqtextfontprec(fp)
 *        Gtxfp *fp;
 *
 *
 *
 *    FORTRAN SYNTAX:
 *
 *        call gqtxfp(errind,txfont,txprec)
 *        int errind
 *        int txfont
 *        int txprec
 *
 */

#include <stdio.h>
#include <math.h>
#include "gks.h"
#include "config.h"
#include "wsstate.h"
#include "gksstate.h"
#include "device.h"
#include "extern.h"

#ifdef FORTRAN

gqtxfp_(errind,txfont,txprec)
int *errind;
int *txfont;
int *txprec;
{
	*txfont = _gks.curtext.fp.font;
	if( *txfont <= 0 )
	{
		*errind=70;
		return;
	}
	*txprec = _gks.curtext.fp.prec;
	return;
}

#else

gqtxfp(fp)
Gtxfp *fp;

{
	fp->font = _gks.curtext.fp.font;
	if( fp->font <= 0 )
	{
		return(70);
	}
	else
	{
		fp->prec = _gks.curtext.fp.prec;
		return(0);
	}
}

#endif
