/*
 * GKS FUNCTION NAME:  Inquire Normalization Transformation
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        ginqntran(num,tran)
 *        int num;
 *        Gwstran *tran;
 *
 *
 *
 *    FORTRAN SYNTAX:
 *
 *        call gqnt(ntnr,errind,window,viewpt)
 *        integer ntnr,errind
 *        real window(4),viewpt(4)
 *
 */

#include <stdio.h>
#include <math.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "wstable.h"
#include "extern.h"

#ifdef FORTRAN

#define NUM *num

gqnt_(num,errind,window,viewpt)
int *num;
int *errind;
float *window;
float *viewpt;

#else

#define NUM num

gqnt(num,tran)
int num;
Gwstran *tran;

#endif
{
	register struct Gnormtran *nptr;

	if( (NUM < 1) || ( NUM > (NNORMTRAN-1)))
	{
#ifdef FORTRAN
		window[0] = 0.;
		window[1] = 0.;
		window[2] = 0.;
		window[3] = 0.;
		viewpt[0] = 0.;
		viewpt[1] = 0.;
		viewpt[2] = 0.;
		viewpt[3] = 0.;
		*errind=50;
		return;
#else
		tran->w.xmin = 0.;
		tran->w.xmax = 0.;
		tran->w.ymin = 0.;
		tran->w.ymax = 0.;
		tran->v.xmin = 0.;
		tran->v.xmax = 0.;
		tran->v.ymin = 0.;
		tran->v.ymax = 0.;
		return(50);
#endif
	}

	nptr = _gks.normtran + NUM;
#ifdef FORTRAN
	window[0] = nptr->window.xmin;
	window[1] = nptr->window.xmax;
	window[2] = nptr->window.ymin;
	window[3] = nptr->window.ymax;
	viewpt[0] = nptr->viewport.xmin;
	viewpt[1] = nptr->viewport.xmax;
	viewpt[2] = nptr->viewport.ymin;
	viewpt[3] = nptr->viewport.ymax;
	return;
#else
	tran->w = nptr->window;
	tran->v = nptr->viewport;
	return(0);
#endif
}
