/*
 * GKS FUNCTION NAME:  Inquire Maximum Display Surface Size
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        ginqmaxdisplaysize(type,dspsz)
 *        char *type;
 *        Gdspsize *dspsz;
 *
 *
 *
 *    FORTRAN SYNTAX:
 *
 *        call gqmds(wtype,errind,dcunit,rx,ry,lx,ly)
 *        integer wtype,errind,dcunit
 *        real rx,ry
 *        integer lx,ly
 *
 */

#include <stdio.h>
#include <math.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "wstable.h"
#include "extern.h"
extern Gwstable *_wstable[];


#ifdef FORTRAN

#define TYPE *type

gqmds_(type,errind,units,rx,ry,lx,ly)
int *type;
int *errind;
int *units;
float *rx,*ry;
int *lx,*ly;

#else


gqmds(type,dspsz)
char *type;
Gdspsize *dspsz;

#endif
{
	int wstype,dev;
	Gwstable *wsd;

#ifdef FORTRAN
	wstype = *type;
#else
	wstype = gwstype(type);
#endif

	dev = gmajordev(wstype);
	if( (!wstype) || (dev >= _gndevsw)) return(22); 
	
	wsd = _wstable[wstype];

#ifdef FORTRAN
	*units = wsd->dspsize.units;
	*rx = wsd->dspsize.device.x;
	*ry = wsd->dspsize.device.y;
	*lx = wsd->dspsize.raster.x;
	*ly = wsd->dspsize.raster.y;
	*errind = 0;
#else
	*dspsz = wsd->dspsize;
#endif
	return(0);
}
