/*
 * GKS FUNCTION NAME:  Request Locator
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        greqloc(ws,dev,response)
 *        int ws;
 *        int dev;
 *        Gqloc *response;
 *
 *
 *    FORTRAN SYNTAX:
 *
 *        call grqlc(wkid,lcdnr,status,tnr,px,py)
 *        integer wkid,lcdnr
 *        integer status
 *        integer tnr
 *        float px,py
 *
 */

#include <stdio.h>
#include <math.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "wstable.h"
#include "extern.h"
#include "input.h"
extern Gwstable *_wstable[];

static char *name="Request Locator";

#ifdef FORTRAN

#define WS *ws
#define DN *dn

grqlc_(ws,dn,status,tnr,px,py)
int WS;
int DN;
int *status;
int *tnr;
float *px,*py;

#else

#define WS ws
#define DN dn

grqlc(ws,dn,response)
int WS;
int DN;
Gqloc *response;

#endif
{
	int error;
	register Gdevsw *dev;
	register struct Gnormtran *nptr;
	Gwsstatelist *wsptr;
	Gwstable *wsd;
#ifdef FORTRAN
	Gqloc resp;
	Gqloc *response = &resp;
#endif


#ifndef FAST
	if( GKS_STATE_ERROR_7)
	{
		error=7;
		goto gkserror;
	}
	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error=20;
		goto gkserror;
	}
#endif

	wsptr = _gks.workstation[WS];
	if( !wsptr) 
	{
		error=25;
		goto gkserror;
	}

	wsd = _wstable[(wsptr->type)];

#ifndef FAST
	if( (wsd->category != GOUTIN) && (wsd->category != GINPUT))
	{
		error=38;
		goto gkserror;
	}
	if(wsptr->locst.mode != GREQUEST )
	{
		error=141;
		goto gkserror;
	}
#endif

	dev = _gdevsw + gmajordev(wsptr->type);

	/*
	 * if initial position has become invalid, fall back
	 * to center of viewport
	 */
	nptr = _gks.normtran + wsptr->locst.loc.transform;
	response->loc.position = wsptr->locst.loc.position;
	if( (response->loc.position.x < nptr->window.xmin) ||
		(response->loc.position.x > nptr->window.xmax) ||
		(response->loc.position.y < nptr->window.ymin) ||
		(response->loc.position.y > nptr->window.ymax))
	{
		response->loc.position.x = (nptr->viewport.xmin +
									nptr->viewport.xmax)/2.0;
		response->loc.position.y = (nptr->viewport.ymin +
									nptr->viewport.ymax)/2.0;
	}
	else
	{
		response->loc.position.x = response->loc.position.x
						* nptr->xscale + nptr->xshift;
		response->loc.position.y = response->loc.position.y
						* nptr->yscale + nptr->yshift;
	}

	/*
	 * call devices locator routine
	 */
	if(error = (*(dev->locator))(wsptr,DN,response)) goto gkserror;

	if(response->status == GOK)
	{
		/*
		 * search norm transforms by priority
		 */
		for(nptr=_gks.highnormtran; nptr != 0; nptr = nptr->lower)
		{
			if((response->loc.position.x >= nptr->viewport.xmin)&&
			   (response->loc.position.x <= nptr->viewport.xmax)&&
			   (response->loc.position.y >= nptr->viewport.ymin)&&
			   (response->loc.position.y <= nptr->viewport.ymax))
				break;
		}
		if(nptr)
		{
			/*
			 * untransform to WC
			 */
#ifdef FORTRAN
			*px = (response->loc.position.x - nptr->xshift)/(nptr->xscale);
			*py = (response->loc.position.y - nptr->yshift)/(nptr->yscale);
			*status = response->status;
			*tnr = nptr - _gks.normtran;
#else
			response->loc.position.x = (response->loc.position.x
								- nptr->xshift)/(nptr->xscale);
			response->loc.position.y = (response->loc.position.y
								- nptr->yshift)/(nptr->yscale);
			response->loc.transform = nptr - _gks.normtran;
#endif
			return(0);
		}
		else
		{
			/*
			 * should never get here because device routines
			 * should always return a point in unit square
			 * if locator status is OK, but!
			 */
#ifdef FORTRAN
			*status = GNONE;
#else
			response->status = GNONE;
#endif
			return(0);
		}
	}
	else
	{
#ifdef FORTRAN
		*status = GNONE;
#else
		response->status = GNONE;
#endif
		return(0);
	}

gkserror:
	gerrorhand(error,name);
	return(error);
}
