/*
 * GKS FUNCTION NAME:  Initialize Locator
 *
 *    C SYNTAX:
 *
 *        #include <gks.h>
 *
 *        ginitloc(ws,dev,init,pet,area,record)
 *        int ws;
 *        int dev;
 *        Gloc *init;
 *        int pet;
 *        Glimit *area;
 *        Glocrec *record;
 *
 *
 *    FORTRAN SYNTAX:
 *
 *        call ginlc(wkid,lcdnr,tnr,ipx,ipy,pet,xmin,xmax,ymin,ymax,ldr,datrec)
 *        integer wkid,lcdnr
 *        integer tnr
 *        float ipx,ipy
 *        integer pet
 *        float xmin,xmax,ymin,ymax
 *        integer ldr
 *        character*80 datrec(ldr)
 *
 */

#include <stdio.h>
#include <math.h>
#include "gks.h"
#include "config.h"
#include "device.h"
#include "wsstate.h"
#include "gksstate.h"
#include "wstable.h"
#include "extern.h"
#include "input.h"
extern Gwstable *_wstable[];

static char *name="Initialize Locator";

#ifdef FORTRAN

#define WS *ws
#define DEV *dev
#define PET *pet

ginlc_(ws,dev,ntn,ipx,ipy,pet,xmin,xmax,ymin,ymax,ldr,datrec)
int WS;
int DEV;
int *ntn;
float *ipx,*ipy;
int PET;
float *xmin,*xmax,*ymin,*ymax;
int *ldr;
char *datrec;

#else

#define WS ws
#define DEV dev
#define PET pet

ginlc(ws,dev,init,pet,area,record)
int WS;
int DEV;
Gloc *init;
int PET;
Glimit *area;
Glocrec *record;

#endif
{
	int error;
	Gwstable *wsd;
	Gwsstatelist *wsptr;
	struct Gnormtran *nptr;
#ifdef FORTRAN
	Gloc loc;
	Gloc *init= &loc;
	init->transform = *ntn;
	init->position.x = *ipx;
	init->position.y = *ipy;
#endif


#ifndef FAST
	if( GKS_STATE_ERROR_7)
	{
		error=7;
		goto gkserror;
	}
	if( (WS < 1) || (WS > NWORKSTATION))
	{
		error=20;
		goto gkserror;
	}
#endif

	wsptr = _gks.workstation[WS];
	if( !wsptr) 
	{
		error=25;
		goto gkserror;
	}
	wsd = _wstable[(wsptr->type)];

#ifndef FAST
	if( (wsd->category != GOUTIN) && (wsd->category != GINPUT))
	{
		error=38;
		goto gkserror;
	}
	if(wsptr->locst.mode != GREQUEST )
	{
		error=141;
		goto gkserror;
	}
	if( (init->transform < 0) || (init->transform >= NNORMTRAN))
	{
		error=152;
		goto gkserror;
	}
#endif

	nptr = _gks.normtran + init->transform;

#ifndef FAST
	if( (init->position.x < nptr->window.xmin) ||
		(init->position.x > nptr->window.xmax) ||
		(init->position.y < nptr->window.ymin) ||
		(init->position.y > nptr->window.ymax))
	{
		error=152;
		goto gkserror;
	}
#endif

	wsptr->locst.loc = *init;
	wsptr->locst.pet = PET;
	return(0);

gkserror:
	gerrorhand(error,name);
	return(error);
}
