/*
 * GKS graphics implementation
 * Copyright (c) 1985  Glenn C. Kroeger
 * 
 * Metafile command byte definitions
 * 		this command language is used for 
 *			1. Metafile workstations
 *			2. Workstation Independent Segment Storage
 *			3. Commands for device routines
 */


/*
 *-----------------------------------------------------------------------
 * COMMAND GROUPS
 *-----------------------------------------------------------------------
 * these are the high 3 bits of the command byte and are used to select
 * the subroutine which will process the command
 */	

#define		SET						0x20	/* primitive attributes   */
#define		CLIPPING				0x40	/* clipping viewport      */
#define		WORKSTATION				0x60	/* workstation control    */
#define		SET_WORKSTATION			0x80	/* workstation attributes */
#define		SEGMENT					0xa0	/* segment control        */
#define		SET_SEGMENT				0xc0	/* segment attributes     */

/*
 *-----------------------------------------------------------------------
 * WORKSTATION control
 *-----------------------------------------------------------------------
 * e.g  (SEND_MESSAGE_TO|WORKSTATION)
 *	or	(CLEAR|WORKSTATION)
 */
#define		CLEAR						0x00
#define 	REDRAW_ALL_SEGMENTS_ON		0x01
#define		UPDATE						0x02
#define 	SET_DEFFERAL_STATE_OF		0x03
#define		SEND_MESSAGE_TO				0x04
#define		SEND_ESCAPE_TO				0x05

/*
 *-----------------------------------------------------------------------
 * OUTPUT 
 *-----------------------------------------------------------------------
 * these are the complete command bytes
 */
#define		LINE			000
#define		MARKER			010
#define		TEXT			020
#define		FILL	 		030
#define		CELL			002
#define		GDP				004

#define		THREE_D			001

/*
 *-----------------------------------------------------------------------
 * SET  output attributes
 *-----------------------------------------------------------------------
 * e.g.  (SET|LINE|WIDTH)
 *		 (SET|PICK_ID)
 */
/* no primitive given */
#define		ASFS				04
#define		PICK_ID				05

/* attributes common to all primitives */
#define		INDEX				00
#define 	COLOR				01

/* line and marker attribute */
#define		TYPE				02

/* line attribute */
#define		WIDTH				03

/* marker attribute */
#define		SIZE				03

/* fill attributes */
#define		STYLE				02
#define 	PATTERN				03
#define 	BORDER				04

/* text attributes */
#define		FONT_PREC			02
#define		ALIGNMENT			03
#define		PATH				04
#define		HEIGHTxWIDTH		05
#define		UP					06	
#define		SPACING				07

/*
 *-----------------------------------------------------------------------
 * CLIPPING
 *-----------------------------------------------------------------------
 * only command is (CLIPPING|RECTANGLE) 
 */
#define		RECTANGLE			01

/*
 *-----------------------------------------------------------------------
 * SET_WORKSTATION attributes
 *-----------------------------------------------------------------------
 * e.g. (SET_WORKSTATION|VIEWPORT)
 */
#define		WINDOW				0x00
#define		VIEWPORT			0x01
#define		LINE_REP			0x02
#define		MARKER_REP			0x03
#define		TEXT_REP			0x04
#define		FILL_REP			0x05
#define		COLOR_REP			0x06
#define		PATTERN_REP			0x07
#define		VIEW_REP			0x08

/*
 *-----------------------------------------------------------------------
 * SEGMENT
 *-----------------------------------------------------------------------
 * e.g. (CREATE|SEGMENT)
 */
#define		CREATE				0x00
#define		CLOSE				0x01
#define		DELETE				0x02
#define		RENAME				0x03

/*
 *-----------------------------------------------------------------------
 * SET_SEGMENT
 *-----------------------------------------------------------------------
 * e.g. (SET_SEGMENT|VISIBILITY)
 */
#define		TRANSFORMATION		0x00
#define		VISIBILITY			0x01
#define		HIGHLIGHTING		0x02
#define		PRIORITY			0x03
#define		DETECTABILITY		0x04
