/*
 * GKS statelist
 */

struct Gnormtran{
	Glimit	window;
	Glimit	viewport;
	struct Gnormtran *higher;
	struct Gnormtran *lower;
	double xscale;
	double yscale;
	double xshift;
	double yshift;
};

typedef struct {
	int state;
	FILE *errfile;

	Gwsstatelist *workstation[NWORKSTATION];

	int curlineindex;
	Glnbundl curline;

	int curmarkerindex;
	Gmkbundl curmarker;

	int curtextindex;
	Gtxbundl curtext;

	float charheight;
	Gpoint charup;

	int textpath;
	Gtxalign textalign;

	Gasfs asfs;

	int curnormtran;
	struct Gnormtran *highnormtran;
	struct Gnormtran normtran[NNORMTRAN];
	int clipind;
	int openseg;
} Gksstatelist;


/*
 * defines for checking GKS state errors
 */

#define GKS_STATE_ERROR_1	(_gks.state != GGKCL)
#define GKS_STATE_ERROR_2	(_gks.state != GGKOP)
#define GKS_STATE_ERROR_3	(_gks.state != GWSAC)
#define GKS_STATE_ERROR_4	(_gks.state != GSGOP)
#define GKS_STATE_ERROR_5	((_gks.state != GWSAC) && (_gks.state != GSGOP))
#define GKS_STATE_ERROR_6	((_gks.state != GWSOP) && (_gks.state != GWSAC))
#define GKS_STATE_ERROR_7	((_gks.state == GGKCL) || (_gks.state == GGKOP))
#define GKS_STATE_ERROR_8	(_gks.state == GGKCL)
